/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.telemetry;

import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.pentaho.telemetry.ITelemetryHandler;
import org.pentaho.telemetry.TelemetryEvent;
import org.pentaho.telemetry.TelemetryEventKeeper;
import org.pentaho.telemetry.TelemetryEventSender;

public class TelemetryHandler
implements ITelemetryHandler {
    private static final int EVENT_QUEUE_CAPACITY = 100;
    protected static final String DEFAULT_TELEMETRY_DIR_NAME = ".telemetry";
    private static final String EVENT_KEEPER_THREAD_NAME = "Telemetry Event Keeper Thread";
    private static final String EVENT_SENDER_THREAD_NAME = "Telemetry Event Sender Thread";
    protected static final long DEFAULT_SEND_PERIOD_IN_MINUTES = 1440L;
    private BlockingQueue<TelemetryEvent> eventQueue;
    private File telemetryDir;
    private long sendPeriodInMinutes;
    private Thread eventKeeperThread;
    private ScheduledThreadPoolExecutor eventSenderThreadPoolExecutor;

    protected BlockingQueue<TelemetryEvent> getEventQueue() {
        return this.eventQueue;
    }

    protected void setEventQueue(BlockingQueue<TelemetryEvent> eventQueue) {
        this.eventQueue = eventQueue;
    }

    public File getTelemetryDir() {
        return this.telemetryDir;
    }

    protected void setTelemetryDir(File telemetryDir) {
        if (!telemetryDir.exists()) {
            telemetryDir.mkdir();
        }
        this.telemetryDir = telemetryDir;
    }

    public long getSendPeriodInMinutes() {
        return this.sendPeriodInMinutes;
    }

    protected void setSendPeriodInMinutes(long sendPeriodInMinutes) {
        this.sendPeriodInMinutes = sendPeriodInMinutes;
    }

    protected Thread getEventKeeperThread() {
        return this.eventKeeperThread;
    }

    protected void setEventKeeperThread(Thread eventKeeperThread) {
        this.eventKeeperThread = eventKeeperThread;
    }

    protected ScheduledThreadPoolExecutor getEventSenderThreadPoolExecutor() {
        return this.eventSenderThreadPoolExecutor;
    }

    protected void setEventSenderThreadPoolExecutor(ScheduledThreadPoolExecutor eventSenderThreadPoolExecutor) {
        this.eventSenderThreadPoolExecutor = eventSenderThreadPoolExecutor;
    }

    public TelemetryHandler() {
        this(DEFAULT_TELEMETRY_DIR_NAME, 1440L);
    }

    public TelemetryHandler(String telemetryDirPath, long sendPeriodInMinutes) {
        this.setEventQueue(new ArrayBlockingQueue<TelemetryEvent>(100));
        this.setTelemetryDir(new File(telemetryDirPath));
        this.setSendPeriodInMinutes(sendPeriodInMinutes);
    }

    public void init() {
        this.startEventKeeper();
        this.startEventSender();
    }

    public void destroy() {
        this.stopEventKeeper();
        this.stopEventSender();
    }

    @Override
    public boolean queueEvent(TelemetryEvent event) {
        BlockingQueue<TelemetryEvent> eventQueue = this.getEventQueue();
        return eventQueue.offer(event);
    }

    private void startEventKeeper() {
        TelemetryEventKeeper eventKeeper = new TelemetryEventKeeper(this.getEventQueue(), this.getTelemetryDir());
        Thread thread = new Thread(eventKeeper);
        thread.setName(EVENT_KEEPER_THREAD_NAME);
        thread.setDaemon(true);
        this.setEventKeeperThread(thread);
        thread.start();
    }

    private void stopEventKeeper() {
        Thread thread = this.getEventKeeperThread();
        thread.interrupt();
    }

    private void startEventSender() {
        TelemetryEventSender eventSender = new TelemetryEventSender(this.getTelemetryDir());
        ScheduledThreadPoolExecutor threadPoolExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(TelemetryHandler.EVENT_SENDER_THREAD_NAME);
                thread.setDaemon(true);
                return thread;
            }
        }, new ThreadPoolExecutor.DiscardPolicy());
        this.setEventSenderThreadPoolExecutor(threadPoolExecutor);
        threadPoolExecutor.scheduleAtFixedRate(eventSender, 0L, this.getSendPeriodInMinutes(), TimeUnit.MINUTES);
    }

    private void stopEventSender() {
        ScheduledThreadPoolExecutor threadPoolExecutor = this.getEventSenderThreadPoolExecutor();
        threadPoolExecutor.shutdown();
    }
}

