/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jam.internal;

import org.codehaus.jam.JClass;
import org.codehaus.jam.JamClassIterator;
import org.codehaus.jam.JamClassLoader;
import org.codehaus.jam.JamService;
import org.codehaus.jam.internal.elements.ElementContext;

public class JamServiceImpl
implements JamService {
    private ElementContext mContext;
    private String[] mClassNames;

    public JamServiceImpl(ElementContext ctx, String[] classes) {
        if (ctx == null) {
            throw new IllegalArgumentException("null jcl");
        }
        if (classes == null) {
            throw new IllegalArgumentException("null classes");
        }
        this.mContext = ctx;
        this.mClassNames = classes;
    }

    public JamClassLoader getClassLoader() {
        return this.mContext.getClassLoader();
    }

    public String[] getClassNames() {
        return this.mClassNames;
    }

    public JamClassIterator getClasses() {
        return new JamClassIterator(this.getClassLoader(), this.getClassNames());
    }

    public JClass[] getAllClasses() {
        JClass[] out = new JClass[this.mClassNames.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.getClassLoader().loadClass(this.mClassNames[i]);
        }
        return out;
    }

    public void setClassNames(String[] names) {
        this.mClassNames = names;
    }
}

