/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionList;
import com.ibm.as400.access.ConnectionPool;
import com.ibm.as400.access.ConnectionPoolEvent;
import com.ibm.as400.access.ConnectionPoolException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Log;
import com.ibm.as400.access.PoolItem;
import com.ibm.as400.access.PoolMaintenance;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class AS400ConnectionPool
extends ConnectionPool
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private transient Hashtable as400ConnectionPool_;
    private transient Hashtable removedAS400ConnectionPool_;
    private transient Log log_;
    private SocketProperties socketProperties_;
    private transient long lastRun_ = 0L;

    public AS400ConnectionPool() {
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupConnections() {
        Serializable serializable = this.as400ConnectionPool_;
        synchronized (serializable) {
            Enumeration enumeration = this.as400ConnectionPool_.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                try {
                    ConnectionList connectionList = (ConnectionList)this.as400ConnectionPool_.get(string);
                    connectionList.removeAndReplace(this.poolListeners_);
                }
                catch (Exception exception) {
                    this.log(exception, string);
                }
            }
        }
        if (this.poolListeners_ != null) {
            serializable = new ConnectionPoolEvent(this, 5);
            this.poolListeners_.fireMaintenanceThreadRun((ConnectionPoolEvent)serializable);
        }
        this.lastRun_ = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.log(ResourceBundleLoader.getText("AS400CP_SHUTDOWN"));
        Serializable serializable = this.as400ConnectionPool_;
        synchronized (serializable) {
            Enumeration enumeration = this.as400ConnectionPool_.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ConnectionList connectionList = (ConnectionList)this.as400ConnectionPool_.get(string);
                connectionList.close();
            }
            this.as400ConnectionPool_.clear();
        }
        if (this.maintenance_ != null && this.maintenance_.isAlive()) {
            this.maintenance_.shutdown();
        }
        if (this.poolListeners_ != null) {
            serializable = new ConnectionPoolEvent(this, 0);
            this.poolListeners_.fireClosedEvent((ConnectionPoolEvent)serializable);
        }
        this.log(ResourceBundleLoader.getText("AS400CP_SHUTDOWNCOMP"));
    }

    private String createKey(String string, String string2) {
        string = string.trim();
        string2 = string2.trim();
        return string.toUpperCase() + "/" + string2.toUpperCase();
    }

    public void fill(String string, String string2, String string3, int n, int n2) throws ConnectionPoolException {
        this.fill(string, string2, string3, n, n2, null);
    }

    public void fill(String string, String string2, String string3, int n, int n2, Locale locale) throws ConnectionPoolException {
        if (n2 < 1) {
            throw new ExtendedIllegalArgumentException("numberOfConnections", 4);
        }
        Vector<AS400> vector = new Vector<AS400>();
        if (Trace.isTraceOn()) {
            Trace.log(3, "fill() key before resolving= " + string + "/" + string2);
        }
        string = AS400.resolveSystem(string);
        string2 = AS400.resolveUserId(string2.toUpperCase());
        String string4 = this.createKey(string, string2);
        if (Trace.isTraceOn()) {
            Trace.log(3, "fill() key after resolving= " + string4);
        }
        try {
            int n3;
            ConnectionList connectionList = (ConnectionList)this.as400ConnectionPool_.get(string4);
            this.log(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_FILLING"), new String[]{new Integer(n2).toString(), string, string2}));
            for (n3 = 0; n3 < n2; ++n3) {
                vector.addElement(this.getConnection(string, string2, n, true, false, locale, string3));
            }
            connectionList = (ConnectionList)this.as400ConnectionPool_.get(string4);
            for (n3 = 0; n3 < n2; ++n3) {
                connectionList.findElement((AS400)vector.elementAt(n3)).setInUse(false);
            }
            if (Trace.isTraceOn() && locale != null) {
                Trace.log(3, "created " + n2 + "with a locale");
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            ConnectionList connectionList = (ConnectionList)this.as400ConnectionPool_.get(string4);
            for (int i = 0; i < vector.size(); ++i) {
                connectionList.findElement((AS400)vector.elementAt(i)).setInUse(false);
            }
            if (this.maintenance_ != null && this.maintenance_.isRunning()) {
                this.cleanupConnections();
            }
            this.log(ResourceBundleLoader.getText("AS400CP_FILLEXC"));
            throw new ConnectionPoolException(aS400SecurityException);
        }
        catch (IOException iOException) {
            ConnectionList connectionList = (ConnectionList)this.as400ConnectionPool_.get(string4);
            for (int i = 0; i < vector.size(); ++i) {
                connectionList.findElement((AS400)vector.elementAt(i)).setInUse(false);
            }
            if (this.maintenance_ != null && this.maintenance_.isRunning()) {
                this.cleanupConnections();
            }
            this.log(ResourceBundleLoader.getText("AS400CP_FILLEXC"));
            throw new ConnectionPoolException(iOException);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public int getActiveConnectionCount(String string, String string2) {
        ConnectionList connectionList;
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            throw new NullPointerException("userID");
        }
        string = AS400.resolveSystem(string);
        string2 = AS400.resolveUserId(string2.toUpperCase());
        String string3 = this.createKey(string, string2);
        if (Trace.isTraceOn()) {
            Trace.log(3, "getActiveConnectionCount key= " + string3);
        }
        if ((connectionList = (ConnectionList)this.as400ConnectionPool_.get(string3)) == null) {
            if (Trace.isTraceOn()) {
                Trace.log(4, "getActiveConnectionCount found no " + string3 + " list in the pool");
            }
            return 0;
        }
        return connectionList.getActiveConnectionCount();
    }

    public int getAvailableConnectionCount(String string, String string2) {
        ConnectionList connectionList;
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            throw new NullPointerException("userID");
        }
        string = AS400.resolveSystem(string);
        string2 = AS400.resolveUserId(string2.toUpperCase());
        String string3 = this.createKey(string, string2);
        if (Trace.isTraceOn()) {
            Trace.log(3, "getAvailableConnectionCount key= " + string3);
        }
        if ((connectionList = (ConnectionList)this.as400ConnectionPool_.get(string3)) == null) {
            if (Trace.isTraceOn()) {
                Trace.log(4, "getAvailableConnectionCount found no " + string3 + "list in the pool");
            }
            return 0;
        }
        return connectionList.getAvailableConnectionCount();
    }

    public AS400 getConnection(String string, String string2, String string3, int n) throws ConnectionPoolException {
        try {
            AS400 aS400 = this.getConnection(string, string2, n, true, false, null, string3);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(aS400, 2);
                this.poolListeners_.fireConnectionReleasedEvent(connectionPoolEvent);
            }
            return aS400;
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ConnectionPoolException(aS400SecurityException);
        }
        catch (IOException iOException) {
            throw new ConnectionPoolException(iOException);
        }
    }

    public AS400 getConnection(String string, String string2, String string3, int n, Locale locale) throws ConnectionPoolException {
        try {
            AS400 aS400 = this.getConnection(string, string2, n, true, false, locale, string3);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(aS400, 2);
                this.poolListeners_.fireConnectionReleasedEvent(connectionPoolEvent);
            }
            return aS400;
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ConnectionPoolException(aS400SecurityException);
        }
        catch (IOException iOException) {
            throw new ConnectionPoolException(iOException);
        }
    }

    public AS400 getConnection(String string, String string2, int n) throws ConnectionPoolException {
        throw new ConnectionPoolException(new ExtendedIOException(23));
    }

    public AS400 getConnection(String string, String string2, String string3) throws ConnectionPoolException {
        try {
            AS400 aS400 = this.getConnection(string, string2, 0, false, false, null, string3);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(aS400, 2);
                this.poolListeners_.fireConnectionReleasedEvent(connectionPoolEvent);
            }
            return aS400;
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ConnectionPoolException(aS400SecurityException);
        }
        catch (IOException iOException) {
            throw new ConnectionPoolException(iOException);
        }
    }

    public AS400 getConnection(String string, String string2, String string3, Locale locale) throws ConnectionPoolException {
        try {
            AS400 aS400 = this.getConnection(string, string2, 0, false, false, locale, string3);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(aS400, 2);
                this.poolListeners_.fireConnectionReleasedEvent(connectionPoolEvent);
            }
            return aS400;
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ConnectionPoolException(aS400SecurityException);
        }
        catch (IOException iOException) {
            throw new ConnectionPoolException(iOException);
        }
    }

    public AS400 getConnection(String string, String string2) throws ConnectionPoolException {
        throw new ConnectionPoolException(new ExtendedIOException(23));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AS400 getConnection(String string, String string2, int n, boolean bl, boolean bl2, Locale locale, String string3) throws AS400SecurityException, IOException, ConnectionPoolException {
        Object object;
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("systemName", 1);
        }
        if (string2 == null) {
            throw new NullPointerException("userID");
        }
        if (string2.length() == 0) {
            throw new ExtendedIllegalArgumentException("userID", 1);
        }
        if (Trace.traceOn_) {
            Trace.log(3, "getConnection() key before resolving= " + string + "/" + string2);
        }
        string = AS400.resolveSystem(string);
        string2 = AS400.resolveUserId(string2.toUpperCase());
        String string4 = this.createKey(string, string2);
        if (Trace.traceOn_) {
            Trace.log(3, "getConnection() key after resolving= " + string4);
        }
        if (!this.isInUse()) {
            this.setInUse(true);
        }
        if (this.isThreadUsed() && this.isRunMaintenance()) {
            if (this.maintenance_ == null) {
                object = this;
                synchronized (object) {
                    if (this.maintenance_ == null) {
                        this.maintenance_ = new PoolMaintenance(this);
                        this.maintenance_.start();
                    }
                }
            }
            if (!this.maintenance_.isRunning()) {
                this.maintenance_.setRunning(true);
            }
        } else if (!this.isThreadUsed() && this.isRunMaintenance() && System.currentTimeMillis() - this.lastRun_ > this.getCleanupInterval()) {
            this.cleanupConnections();
        }
        if ((object = (ConnectionList)this.as400ConnectionPool_.get(string4)) == null) {
            Hashtable hashtable = this.as400ConnectionPool_;
            synchronized (hashtable) {
                object = (ConnectionList)this.as400ConnectionPool_.get(string4);
                if (object == null) {
                    if (this.log_ != null) {
                        this.log(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_CONNLIST"), new String[]{string, string2}));
                    }
                    object = new ConnectionList(string, string2, this.properties_);
                    ((ConnectionList)object).setLog(this.log_);
                    this.as400ConnectionPool_.put(string4, object);
                }
            }
        }
        if (bl) {
            return ((ConnectionList)object).getConnection(n, bl2, this.poolListeners_, locale, string3, this.socketProperties_).getAS400Object();
        }
        return ((ConnectionList)object).getConnection(bl2, this.poolListeners_, locale, string3, this.socketProperties_).getAS400Object();
    }

    public AS400 getSecureConnection(String string, String string2, String string3) throws ConnectionPoolException {
        try {
            AS400 aS400 = this.getConnection(string, string2, 0, false, true, null, string3);
            aS400.getVRM();
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(aS400, 2);
                this.poolListeners_.fireConnectionReleasedEvent(connectionPoolEvent);
            }
            return aS400;
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ConnectionPoolException(aS400SecurityException);
        }
        catch (IOException iOException) {
            throw new ConnectionPoolException(iOException);
        }
    }

    public AS400 getSecureConnection(String string, String string2) throws ConnectionPoolException {
        throw new ConnectionPoolException(new ExtendedIOException(23));
    }

    public AS400 getSecureConnection(String string, String string2, String string3, int n) throws ConnectionPoolException {
        try {
            AS400 aS400 = this.getConnection(string, string2, n, true, true, null, string3);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(aS400, 2);
                this.poolListeners_.fireConnectionReleasedEvent(connectionPoolEvent);
            }
            return aS400;
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ConnectionPoolException(aS400SecurityException);
        }
        catch (IOException iOException) {
            throw new ConnectionPoolException(iOException);
        }
    }

    public AS400 getSecureConnection(String string, String string2, int n) throws ConnectionPoolException {
        throw new ConnectionPoolException(new ExtendedIOException(23));
    }

    public SocketProperties getSocketProperties() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting socket properties.");
        }
        if (this.socketProperties_ == null) {
            return null;
        }
        SocketProperties socketProperties = new SocketProperties();
        socketProperties.copyValues(this.socketProperties_);
        return socketProperties;
    }

    public String[] getSystemNames() {
        Object[] objectArray;
        Enumeration enumeration = this.as400ConnectionPool_.keys();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            String string = objectArray.substring(0, objectArray.indexOf("/"));
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Enumeration getUsers() {
        return this.as400ConnectionPool_.keys();
    }

    public String[] getUsers(String string) {
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        return this.getUsers(string, false);
    }

    public String[] getConnectedUsers(String string) {
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        return this.getUsers(string, true);
    }

    private String[] getUsers(String string, boolean bl) {
        Object[] objectArray;
        Enumeration enumeration = this.as400ConnectionPool_.keys();
        Vector<String> vector = new Vector<String>();
        string = string.toUpperCase().trim();
        String string2 = string + "/";
        while (enumeration.hasMoreElements()) {
            String string3;
            objectArray = (Object[])enumeration.nextElement();
            if (!objectArray.startsWith(string2)) continue;
            ConnectionList connectionList = (ConnectionList)this.as400ConnectionPool_.get(objectArray);
            if (bl && !connectionList.hasConnectedConnection() || vector.contains(string3 = objectArray.substring(objectArray.indexOf("/") + 1))) continue;
            vector.addElement(string3);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void initializeTransient() {
        this.as400ConnectionPool_ = new Hashtable();
        this.removedAS400ConnectionPool_ = new Hashtable();
        this.lastRun_ = System.currentTimeMillis();
    }

    private void log(String string) {
        if (Trace.isTraceOn()) {
            Trace.log(3, string);
        }
        if (this.log_ != null) {
            this.log_.log(string);
        }
    }

    private void log(Exception exception, String string) {
        if (Trace.isTraceOn()) {
            Trace.log(2, string, (Throwable)exception);
        }
        if (this.log_ != null) {
            this.log_.log(string, exception);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeFromPool(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            throw new NullPointerException("userID");
        }
        String string3 = this.createKey(string = AS400.resolveSystem(string), string2 = AS400.resolveUserId(string2.toUpperCase()));
        ConnectionList connectionList = (ConnectionList)this.as400ConnectionPool_.get(string3);
        if (connectionList != null) {
            connectionList.removeUnusedElements();
            this.removedAS400ConnectionPool_.put(string3, connectionList);
            this.as400ConnectionPool_.remove(string3);
        } else if (Trace.traceOn_) {
            Trace.log(4, "A list of connections for: " + string3 + "does not exist");
        }
    }

    public void returnConnectionToPool(AS400 aS400) {
        Object object;
        Object object2;
        Object object3;
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (Trace.traceOn_) {
            Trace.log(3, "returnConnectionToPool key= " + aS400.getSystemName() + "/" + aS400.getUserId());
        }
        String string = this.createKey(aS400.getSystemName(), aS400.getUserId());
        ConnectionList connectionList = (ConnectionList)this.as400ConnectionPool_.get(string);
        PoolItem poolItem = null;
        if (connectionList != null) {
            poolItem = connectionList.findElement(aS400);
        }
        if (poolItem != null) {
            poolItem.setInUse(false);
            if (this.log_ != null) {
                this.log(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_RETCONN"), new String[]{aS400.getSystemName(), aS400.getUserId()}));
            }
            if (this.poolListeners_ != null) {
                object3 = new ConnectionPoolEvent(poolItem.getAS400Object(), 3);
                this.poolListeners_.fireConnectionReturnedEvent((ConnectionPoolEvent)object3);
            }
            if (Trace.traceOn_) {
                Trace.log(3, "returned connection to pool");
            }
        }
        if (poolItem == null) {
            object3 = this.as400ConnectionPool_.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = (ConnectionList)this.as400ConnectionPool_.get(object2);
                poolItem = ((ConnectionList)object).findElement(aS400);
                if (poolItem == null) continue;
                if (Trace.traceOn_) {
                    Trace.log(4, "connection belongs to a different list than expected");
                }
                poolItem.getAS400Object().disconnectAllServices();
                ((ConnectionList)object).removeElement(aS400);
                break;
            }
        }
        if (poolItem == null) {
            object3 = (ConnectionList)this.removedAS400ConnectionPool_.get(string);
            if (object3 != null) {
                poolItem = ((ConnectionList)object3).findElement(aS400);
            }
            if (poolItem != null) {
                poolItem.getAS400Object().disconnectAllServices();
                ((ConnectionList)object3).removeElement(aS400);
                if (this.log_ != null) {
                    this.log(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_RETCONN"), new String[]{aS400.getSystemName(), aS400.getUserId()}));
                }
                if (this.poolListeners_ != null) {
                    object2 = new ConnectionPoolEvent(poolItem.getAS400Object(), 3);
                    this.poolListeners_.fireConnectionReturnedEvent((ConnectionPoolEvent)object2);
                }
                if (Trace.traceOn_) {
                    Trace.log(3, "returned connection to removed pool");
                }
            }
            if (poolItem == null) {
                object2 = this.removedAS400ConnectionPool_.keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    ConnectionList connectionList2 = (ConnectionList)this.removedAS400ConnectionPool_.get(object);
                    poolItem = connectionList2.findElement(aS400);
                    if (poolItem == null) continue;
                    poolItem.getAS400Object().disconnectAllServices();
                    connectionList2.removeElement(aS400);
                    if (!Trace.traceOn_) break;
                    Trace.log(3, "returned connection to removed pool");
                    break;
                }
            }
            if (poolItem == null && Trace.traceOn_) {
                Trace.log(4, "connection does not belong to this pool");
            }
        }
        if (!this.isThreadUsed() && this.isRunMaintenance() && System.currentTimeMillis() - this.lastRun_ > this.getCleanupInterval()) {
            this.cleanupConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runMaintenance(boolean bl) {
        if (this.maintenance_ != null) {
            PoolMaintenance poolMaintenance = this.maintenance_;
            synchronized (poolMaintenance) {
                if (this.maintenance_.isRunning()) {
                    ConnectionList connectionList;
                    String string;
                    Enumeration enumeration;
                    Hashtable hashtable;
                    if (bl) {
                        hashtable = this.as400ConnectionPool_;
                        synchronized (hashtable) {
                            enumeration = this.as400ConnectionPool_.keys();
                            while (enumeration.hasMoreElements()) {
                                string = (String)enumeration.nextElement();
                                try {
                                    connectionList = (ConnectionList)this.as400ConnectionPool_.get(string);
                                    connectionList.shutDownOldest();
                                }
                                catch (Exception exception) {
                                    this.log(exception, string);
                                }
                            }
                        }
                    }
                    hashtable = this.removedAS400ConnectionPool_;
                    synchronized (hashtable) {
                        enumeration = this.removedAS400ConnectionPool_.keys();
                        while (enumeration != null && enumeration.hasMoreElements()) {
                            string = (String)enumeration.nextElement();
                            connectionList = (ConnectionList)this.removedAS400ConnectionPool_.get(string);
                            if (connectionList.removeUnusedElements()) continue;
                            this.removedAS400ConnectionPool_.remove(string);
                        }
                    }
                    this.maintenance_.notify();
                }
            }
        }
    }

    public void setLog(Log log) {
        this.log_ = log;
    }

    public void setSocketProperties(SocketProperties socketProperties) {
        this.socketProperties_ = socketProperties;
    }
}

