/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLBigint
implements SQLData {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private int truncated_ = 0;
    private long value_ = 0L;
    private int vrm_;

    SQLBigint(int n) {
        this.vrm_ = n;
    }

    public Object clone() {
        return new SQLBigint(this.vrm_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.value_ = BinaryConverter.byteArrayToLong(byArray, n);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.longToByteArray(this.value_, byArray, n);
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        this.truncated_ = 0;
        if (object instanceof String) {
            try {
                this.value_ = Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    BigInteger bigInteger = new BigDecimal((String)object).toBigInteger();
                    if (bigInteger.compareTo(LONG_MAX_VALUE) > 0 || bigInteger.compareTo(LONG_MIN_VALUE) < 0) {
                        this.truncated_ = bigInteger.toByteArray().length - 8;
                        if (this.vrm_ >= JDUtilities.vrm610) {
                            JDError.throwSQLException(this, "07006");
                        }
                    }
                    this.value_ = bigInteger.longValue();
                }
                catch (NumberFormatException numberFormatException2) {
                    JDError.throwSQLException((Object)this, "07006", numberFormatException2);
                }
            }
        } else if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
                this.truncated_ = 1;
            }
            this.value_ = ((Number)object).longValue();
        } else if (object instanceof Boolean) {
            this.value_ = (Boolean)object == true ? 1L : 0L;
        } else {
            JDError.throwSQLException(this, "07006");
        }
    }

    public int getSQLType() {
        return 1;
    }

    public String getJavaClassName() {
        return "java.lang.Long";
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 20;
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "BIGINT";
    }

    public int getMaximumPrecision() {
        return 19;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 492;
    }

    public int getPrecision() {
        return 19;
    }

    public int getRadix() {
        return 10;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return -5;
    }

    public String getTypeName() {
        return "BIGINT";
    }

    public boolean isSigned() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return 8;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(Long.toString(this.value_)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        if (n <= 0) {
            return BigDecimal.valueOf(this.value_);
        }
        return BigDecimal.valueOf(this.value_).setScale(n);
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        return new ByteArrayInputStream(BinaryConverter.longToByteArray(this.value_));
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        byte[] byArray = BinaryConverter.longToByteArray(this.value_);
        return new AS400JDBCBlob(byArray, byArray.length);
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        return this.value_ != 0L;
    }

    public byte getByte() throws SQLException {
        if (this.value_ > 127L || this.value_ < -128L) {
            this.truncated_ = this.value_ > 32767L || this.value_ < -32768L ? (this.value_ > Integer.MAX_VALUE || this.value_ < Integer.MIN_VALUE ? 7 : 3) : 1;
        }
        return (byte)this.value_;
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        return BinaryConverter.longToByteArray(this.value_);
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        return new StringReader(Long.toString(this.value_));
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        String string = Long.toString(this.value_);
        return new AS400JDBCClob(string, string.length());
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        return this.value_;
    }

    public float getFloat() throws SQLException {
        this.truncated_ = (float)this.value_ > Float.MAX_VALUE || (float)this.value_ < -3.4028235E38f ? 4 : 0;
        return this.value_;
    }

    public int getInt() throws SQLException {
        this.truncated_ = this.value_ > Integer.MAX_VALUE || this.value_ < Integer.MIN_VALUE ? 4 : 0;
        return (int)this.value_;
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        return this.value_;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        return new Long(this.value_);
    }

    public short getShort() throws SQLException {
        if (this.value_ > 32767L || this.value_ < -32768L) {
            this.truncated_ = this.value_ > Integer.MAX_VALUE || this.value_ < Integer.MIN_VALUE ? 6 : 2;
        }
        return (short)this.value_;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        return Long.toString(this.value_);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(Long.toString(this.value_)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }
}

