/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.twill.api.LocalFile;
import org.apache.twill.api.RunId;
import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.filesystem.Location;
import org.apache.twill.internal.AbstractZKServiceController;
import org.apache.twill.internal.ContainerLiveNodeData;
import org.apache.twill.internal.DefaultLocalFile;
import org.apache.twill.internal.JvmOptions;
import org.apache.twill.internal.ProcessController;
import org.apache.twill.internal.ProcessLauncher;
import org.apache.twill.internal.TwillContainerController;
import org.apache.twill.internal.state.Message;
import org.apache.twill.launcher.FindFreePort;
import org.apache.twill.launcher.TwillLauncher;
import org.apache.twill.zookeeper.NodeData;
import org.apache.twill.zookeeper.OperationFuture;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKOperations;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwillContainerLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(TwillContainerLauncher.class);
    private static final double HEAP_MIN_RATIO = 0.7;
    private final RuntimeSpecification runtimeSpec;
    private final ProcessLauncher.PrepareLaunchContext launchContext;
    private final ZKClient zkClient;
    private final int instanceCount;
    private final JvmOptions jvmOpts;
    private final int reservedMemory;
    private final Location secureStoreLocation;

    public TwillContainerLauncher(RuntimeSpecification runtimeSpec, ProcessLauncher.PrepareLaunchContext launchContext, ZKClient zkClient, int instanceCount, JvmOptions jvmOpts, int reservedMemory, Location secureStoreLocation) {
        this.runtimeSpec = runtimeSpec;
        this.launchContext = launchContext;
        this.zkClient = zkClient;
        this.instanceCount = instanceCount;
        this.jvmOpts = jvmOpts;
        this.reservedMemory = reservedMemory;
        this.secureStoreLocation = secureStoreLocation;
    }

    public TwillContainerController start(RunId runId, int instanceId, Class<?> mainClass, String classPath) {
        String firstCommand;
        Futures.getUnchecked((Future)ZKOperations.ignoreError((OperationFuture)ZKOperations.recursiveDelete((ZKClient)this.zkClient, (String)("/" + runId)), KeeperException.NoNodeException.class, null));
        this.launchContext.addResources(this.runtimeSpec.getLocalFiles());
        try {
            if (this.secureStoreLocation != null && this.secureStoreLocation.exists()) {
                this.launchContext.addResources(new LocalFile[]{new DefaultLocalFile("credentials.store", this.secureStoreLocation.toURI(), this.secureStoreLocation.lastModified(), this.secureStoreLocation.length(), false, null)});
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to launch container with secure store {}.", (Object)this.secureStoreLocation);
        }
        int memory = this.runtimeSpec.getResourceSpecification().getMemorySize();
        memory = (double)(memory - this.reservedMemory) / (double)memory >= 0.7 ? this.runtimeSpec.getResourceSpecification().getMemorySize() - this.reservedMemory : (int)Math.ceil((double)memory * 0.7);
        this.launchContext.addEnvironment("TWILL_RUN_ID", runId.getId()).addEnvironment("TWILL_RUNNABLE_NAME", this.runtimeSpec.getName()).addEnvironment("TWILL_INSTANCE_ID", Integer.toString(instanceId)).addEnvironment("TWILL_INSTANCE_COUNT", Integer.toString(this.instanceCount));
        ImmutableList.Builder commandBuilder = ImmutableList.builder();
        if (this.jvmOpts.getDebugOptions().doDebug(this.runtimeSpec.getName())) {
            String suspend = this.jvmOpts.getDebugOptions().doSuspend() ? "y" : "n";
            firstCommand = "TWILL_DEBUG_PORT=$($JAVA_HOME/bin/java";
            commandBuilder.add((Object[])new String[]{"-cp", "launcher.jar", FindFreePort.class.getName() + ")", "&&", "$JAVA_HOME/bin/java", "-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspend + "," + "address=\\$TWILL_DEBUG_PORT", "-Dtwill.debug.port=\\$TWILL_DEBUG_PORT"});
        } else {
            firstCommand = "$JAVA_HOME/bin/java";
        }
        commandBuilder.add((Object[])new String[]{"-Djava.io.tmpdir=tmp", "-Dyarn.container=$YARN_CONTAINER_ID", "-Dtwill.runnable=$TWILL_APP_NAME.$TWILL_RUNNABLE_NAME", "-cp", "launcher.jar:" + classPath, "-Xmx" + memory + "m"});
        if (this.jvmOpts.getExtraOptions() != null) {
            commandBuilder.add((Object)this.jvmOpts.getExtraOptions());
        }
        commandBuilder.add((Object[])new String[]{TwillLauncher.class.getName(), "container.jar", mainClass.getName(), Boolean.TRUE.toString()});
        ImmutableList command = commandBuilder.build();
        ProcessController<Void> processController = this.launchContext.addCommand(firstCommand, command.toArray(new String[command.size()])).launch();
        TwillContainerControllerImpl controller = new TwillContainerControllerImpl(this.zkClient, runId, processController);
        controller.start();
        return controller;
    }

    private static final class TwillContainerControllerImpl
    extends AbstractZKServiceController
    implements TwillContainerController {
        private final ProcessController<Void> processController;
        private volatile ContainerLiveNodeData liveData;

        protected TwillContainerControllerImpl(ZKClient zkClient, RunId runId, ProcessController<Void> processController) {
            super(runId, zkClient);
            this.processController = processController;
        }

        @Override
        protected void doStartUp() {
        }

        @Override
        protected void doShutDown() {
        }

        @Override
        protected void instanceNodeUpdated(NodeData nodeData) {
            if (nodeData == null || nodeData.getData() == null) {
                LOG.warn("Instance node was updated but data is null.");
                return;
            }
            try {
                JsonElement data;
                Gson gson = new Gson();
                JsonElement json = (JsonElement)gson.fromJson(new String(nodeData.getData(), Charsets.UTF_8), JsonElement.class);
                if (json.isJsonObject() && (data = json.getAsJsonObject().get("data")) != null) {
                    this.liveData = (ContainerLiveNodeData)gson.fromJson(data, ContainerLiveNodeData.class);
                    LOG.info("Container LiveNodeData updated: " + new String(nodeData.getData(), Charsets.UTF_8));
                }
            }
            catch (Throwable t) {
                LOG.warn("Error deserializing updated instance node data", t);
            }
        }

        @Override
        protected void instanceNodeFailed(Throwable cause) {
        }

        @Override
        public ListenableFuture<Message> sendMessage(Message message) {
            return this.sendMessage(message, message);
        }

        @Override
        public synchronized void completed(int exitStatus) {
            this.forceShutDown();
        }

        @Override
        public ContainerLiveNodeData getLiveNodeData() {
            return this.liveData;
        }

        public void kill() {
            this.processController.cancel();
        }
    }
}

