/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.twill.api.EventHandlerSpecification;
import org.apache.twill.api.Hosts;
import org.apache.twill.api.Racks;
import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.api.TwillSpecification;
import org.apache.twill.internal.DefaultEventHandlerSpecification;
import org.apache.twill.internal.DefaultTwillSpecification;

final class TwillSpecificationCodec
implements JsonSerializer<TwillSpecification>,
JsonDeserializer<TwillSpecification> {
    TwillSpecificationCodec() {
    }

    public JsonElement serialize(TwillSpecification src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("name", src.getName());
        json.add("runnables", context.serialize((Object)src.getRunnables(), new TypeToken<Map<String, RuntimeSpecification>>(){}.getType()));
        json.add("orders", context.serialize((Object)src.getOrders(), new TypeToken<List<TwillSpecification.Order>>(){}.getType()));
        json.add("placementPolicies", context.serialize((Object)src.getPlacementPolicies(), new TypeToken<List<TwillSpecification.PlacementPolicy>>(){}.getType()));
        EventHandlerSpecification eventHandler = src.getEventHandler();
        if (eventHandler != null) {
            json.add("handler", context.serialize((Object)eventHandler, EventHandlerSpecification.class));
        }
        return json;
    }

    public TwillSpecification deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        String name = jsonObj.get("name").getAsString();
        Map runnables = (Map)context.deserialize(jsonObj.get("runnables"), new TypeToken<Map<String, RuntimeSpecification>>(){}.getType());
        List orders = (List)context.deserialize(jsonObj.get("orders"), new TypeToken<List<TwillSpecification.Order>>(){}.getType());
        List placementPolicies = (List)context.deserialize(jsonObj.get("placementPolicies"), new TypeToken<List<TwillSpecification.PlacementPolicy>>(){}.getType());
        JsonElement handler = jsonObj.get("handler");
        EventHandlerSpecification eventHandler = null;
        if (handler != null && !handler.isJsonNull()) {
            eventHandler = (EventHandlerSpecification)context.deserialize(handler, EventHandlerSpecification.class);
        }
        return new DefaultTwillSpecification(name, runnables, orders, placementPolicies, eventHandler);
    }

    static final class EventHandlerSpecificationCoder
    implements JsonSerializer<EventHandlerSpecification>,
    JsonDeserializer<EventHandlerSpecification> {
        EventHandlerSpecificationCoder() {
        }

        public JsonElement serialize(EventHandlerSpecification src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("classname", src.getClassName());
            json.add("configs", context.serialize((Object)src.getConfigs(), new TypeToken<Map<String, String>>(){}.getType()));
            return json;
        }

        public EventHandlerSpecification deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObj = json.getAsJsonObject();
            String className = jsonObj.get("classname").getAsString();
            Map configs = (Map)context.deserialize(jsonObj.get("configs"), new TypeToken<Map<String, String>>(){}.getType());
            return new DefaultEventHandlerSpecification(className, configs);
        }
    }

    static final class TwillSpecificationPlacementPolicyCoder
    implements JsonSerializer<TwillSpecification.PlacementPolicy>,
    JsonDeserializer<TwillSpecification.PlacementPolicy> {
        TwillSpecificationPlacementPolicyCoder() {
        }

        public JsonElement serialize(TwillSpecification.PlacementPolicy src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.add("names", context.serialize((Object)src.getNames(), new TypeToken<Set<String>>(){}.getType()));
            json.addProperty("type", src.getType().name());
            json.add("hosts", context.serialize((Object)src.getHosts(), new TypeToken<Set<String>>(){}.getType()));
            json.add("racks", context.serialize((Object)src.getRacks(), new TypeToken<Set<String>>(){}.getType()));
            return json;
        }

        public TwillSpecification.PlacementPolicy deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObj = json.getAsJsonObject();
            Set names = (Set)context.deserialize(jsonObj.get("names"), new TypeToken<Set<String>>(){}.getType());
            TwillSpecification.PlacementPolicy.Type type = TwillSpecification.PlacementPolicy.Type.valueOf((String)jsonObj.get("type").getAsString());
            Set hosts = (Set)context.deserialize(jsonObj.get("hosts"), new TypeToken<Set<String>>(){}.getType());
            Set racks = (Set)context.deserialize(jsonObj.get("racks"), new TypeToken<Set<String>>(){}.getType());
            return new DefaultTwillSpecification.DefaultPlacementPolicy(names, type, new Hosts(hosts), new Racks(racks));
        }
    }

    static final class TwillSpecificationOrderCoder
    implements JsonSerializer<TwillSpecification.Order>,
    JsonDeserializer<TwillSpecification.Order> {
        TwillSpecificationOrderCoder() {
        }

        public JsonElement serialize(TwillSpecification.Order src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.add("names", context.serialize((Object)src.getNames(), new TypeToken<Set<String>>(){}.getType()));
            json.addProperty("type", src.getType().name());
            return json;
        }

        public TwillSpecification.Order deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObj = json.getAsJsonObject();
            Set names = (Set)context.deserialize(jsonObj.get("names"), new TypeToken<Set<String>>(){}.getType());
            TwillSpecification.Order.Type type = TwillSpecification.Order.Type.valueOf((String)jsonObj.get("type").getAsString());
            return new DefaultTwillSpecification.DefaultOrder(names, type);
        }
    }
}

