/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.StringBlob;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.WritableUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.persistence.jdbc.Strategy;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity
@NamedQueries(value={@NamedQuery(name="UPDATE_ACTION", query="update WorkflowActionBean a set a.conf = :conf, a.consoleUrl = :consoleUrl, a.data = :data, a.stats = :stats, a.externalChildIDs = :externalChildIDs, a.errorCode = :errorCode, a.errorMessage = :errorMessage, a.externalId = :externalId, a.externalStatus = :externalStatus, a.name = :name, a.cred = :cred , a.retries = :retries, a.trackerUri = :trackerUri, a.transition = :transition, a.type = :type, a.endTimestamp = :endTime, a.executionPath = :executionPath, a.lastCheckTimestamp = :lastCheckTime, a.logToken = :logToken, a.pending = :pending, a.pendingAgeTimestamp = :pendingAge, a.signalValue = :signalValue, a.slaXml = :slaXml, a.startTimestamp = :startTime, a.statusStr = :status, a.wfId=:wfId where a.id = :id"), @NamedQuery(name="UPDATE_ACTION_FOR_LAST_CHECKED_TIME", query="update WorkflowActionBean a set a.lastCheckTimestamp = :lastCheckTime where a.id = :id"), @NamedQuery(name="UPDATE_ACTION_START", query="update WorkflowActionBean a set a.startTimestamp = :startTime, a.externalChildIDs = :externalChildIDs, a.conf = :conf, a.errorCode = :errorCode, a.errorMessage = :errorMessage, a.startTimestamp = :startTime, a.externalId = :externalId, a.trackerUri = :trackerUri, a.consoleUrl = :consoleUrl, a.lastCheckTimestamp = :lastCheckTime, a.statusStr = :status, a.externalStatus = :externalStatus, a.data = :data, a.retries = :retries, a.pending = :pending, a.pendingAgeTimestamp = :pendingAge, a.userRetryCount = :userRetryCount where a.id = :id"), @NamedQuery(name="UPDATE_ACTION_CHECK", query="update WorkflowActionBean a set a.userRetryCount = :userRetryCount, a.stats = :stats, a.externalChildIDs = :externalChildIDs, a.externalStatus = :externalStatus, a.statusStr = :status, a.data = :data, a.pending = :pending, a.errorCode = :errorCode, a.errorMessage = :errorMessage, a.lastCheckTimestamp = :lastCheckTime, a.retries = :retries, a.pendingAgeTimestamp = :pendingAge, a.startTimestamp = :startTime where a.id = :id"), @NamedQuery(name="UPDATE_ACTION_END", query="update WorkflowActionBean a set a.stats = :stats, a.errorCode = :errorCode, a.errorMessage = :errorMessage, a.retries = :retries, a.endTimestamp = :endTime, a.statusStr = :status, a.pending = :pending, a.pendingAgeTimestamp = :pendingAge, a.signalValue = :signalValue, a.userRetryCount = :userRetryCount, a.externalStatus = :externalStatus where a.id = :id"), @NamedQuery(name="UPDATE_ACTION_PENDING", query="update WorkflowActionBean a set a.pending = :pending, a.pendingAgeTimestamp = :pendingAge, a.executionPath = :executionPath where a.id = :id"), @NamedQuery(name="UPDATE_ACTION_STATUS_PENDING", query="update WorkflowActionBean a set a.statusStr = :status, a.pending = :pending, a.pendingAgeTimestamp = :pendingAge where a.id = :id"), @NamedQuery(name="UPDATE_ACTION_PENDING_TRANS", query="update WorkflowActionBean a set a.pending = :pending, a.pendingAgeTimestamp = :pendingAge, a.transition = :transition where a.id = :id"), @NamedQuery(name="UPDATE_ACTION_PENDING_TRANS_ERROR", query="update WorkflowActionBean a set a.pending = :pending, a.pendingAgeTimestamp = :pendingAge, a.transition = :transition, a.errorCode = :errorCode, a.errorMessage = :errorMessage, a.statusStr = :status where a.id = :id"), @NamedQuery(name="DELETE_ACTION", query="delete from WorkflowActionBean a where a.id IN (:id)"), @NamedQuery(name="DELETE_ACTIONS_FOR_WORKFLOW", query="delete from WorkflowActionBean a where a.wfId IN (:wfId)"), @NamedQuery(name="GET_ACTIONS", query="select OBJECT(a) from WorkflowActionBean a"), @NamedQuery(name="GET_ACTION", query="select OBJECT(a) from WorkflowActionBean a where a.id = :id"), @NamedQuery(name="GET_ACTION_ID_TYPE_LASTCHECK", query="select a.id, a.type, a.lastCheckTimestamp from WorkflowActionBean a where a.id = :id"), @NamedQuery(name="GET_ACTION_FAIL", query="select a.id, a.wfId, a.name, a.statusStr, a.pending, a.type, a.logToken, a.transition, a.errorCode, a.errorMessage from WorkflowActionBean a where a.id = :id"), @NamedQuery(name="GET_ACTION_SIGNAL", query="select a.id, a.wfId, a.name, a.statusStr, a.pending, a.pendingAgeTimestamp, a.type, a.logToken, a.transition, a.errorCode, a.errorMessage, a.executionPath, a.signalValue, a.slaXml, a.externalId from WorkflowActionBean a where a.id = :id"), @NamedQuery(name="GET_ACTION_CHECK", query="select a.id, a.wfId, a.name, a.statusStr, a.pending, a.pendingAgeTimestamp, a.type, a.logToken, a.transition, a.retries, a.userRetryCount, a.userRetryMax, a.userRetryInterval, a.trackerUri, a.startTimestamp, a.endTimestamp, a.lastCheckTimestamp, a.errorCode, a.errorMessage, a.externalId, a.externalStatus, a.externalChildIDs, a.conf from WorkflowActionBean a where a.id = :id"), @NamedQuery(name="GET_ACTION_END", query="select a.id, a.wfId, a.name, a.statusStr, a.pending, a.pendingAgeTimestamp, a.type, a.logToken, a.transition, a.retries, a.trackerUri, a.userRetryCount, a.userRetryMax, a.userRetryInterval, a.startTimestamp, a.endTimestamp, a.errorCode, a.errorMessage, a.externalId, a.externalStatus, a.externalChildIDs, a.conf, a.data, a.stats from WorkflowActionBean a where a.id = :id"), @NamedQuery(name="GET_ACTION_COMPLETED", query="select a.id, a.wfId, a.statusStr, a.type, a.logToken from WorkflowActionBean a where a.id = :id"), @NamedQuery(name="GET_ACTION_FOR_UPDATE", query="select OBJECT(a) from WorkflowActionBean a where a.id = :id"), @NamedQuery(name="GET_ACTION_FOR_SLA", query="select a.id, a.statusStr, a.startTimestamp, a.endTimestamp from WorkflowActionBean a where a.id = :id"), @NamedQuery(name="GET_ACTIONS_FOR_WORKFLOW", query="select OBJECT(a) from WorkflowActionBean a where a.wfId = :wfId order by a.startTimestamp"), @NamedQuery(name="GET_ACTIONS_OF_WORKFLOW_FOR_UPDATE", query="select OBJECT(a) from WorkflowActionBean a where a.wfId = :wfId order by a.startTimestamp"), @NamedQuery(name="GET_PENDING_ACTIONS", query="select a.id, a.wfId, a.statusStr, a.type, a.pendingAgeTimestamp from WorkflowActionBean a where a.pending = 1 AND a.pendingAgeTimestamp < :pendingAge AND a.statusStr <> 'RUNNING' AND a.createdTimeTS >= :createdTime"), @NamedQuery(name="GET_RUNNING_ACTIONS", query="select a.id from WorkflowActionBean a where a.pending = 1 AND a.statusStr = 'RUNNING' AND a.lastCheckTimestamp < :lastCheckTime"), @NamedQuery(name="GET_RETRY_MANUAL_ACTIONS", query="select OBJECT(a) from WorkflowActionBean a where a.wfId = :wfId AND (a.statusStr = 'START_RETRY' OR a.statusStr = 'START_MANUAL' OR a.statusStr = 'END_RETRY' OR a.statusStr = 'END_MANUAL')"), @NamedQuery(name="GET_ACTIONS_FOR_WORKFLOW_RERUN", query="select a.id, a.name, a.statusStr, a.endTimestamp, a.type from WorkflowActionBean a where a.wfId = :wfId order by a.startTimestamp")})
@Table(name="WF_ACTIONS")
public class WorkflowActionBean
implements Writable,
WorkflowAction,
JsonBean,
PersistenceCapable {
    @Id
    private String id;
    @Basic
    @Index
    @Column(name="wf_id")
    private String wfId = null;
    @Basic
    @Column(name="created_time")
    private Timestamp createdTimeTS = null;
    @Basic
    @Index
    @Column(name="status")
    private String statusStr = WorkflowAction.Status.PREP.toString();
    @Basic
    @Index
    @Column(name="last_check_time")
    private Timestamp lastCheckTimestamp;
    @Basic
    @Column(name="end_time")
    private Timestamp endTimestamp = null;
    @Basic
    @Column(name="start_time")
    private Timestamp startTimestamp = null;
    @Basic
    @Column(name="execution_path", length=1024)
    private String executionPath = null;
    @Basic
    @Index
    @Column(name="pending")
    private int pending = 0;
    @Basic
    @Index
    @Column(name="pending_age")
    private Timestamp pendingAgeTimestamp = null;
    @Basic
    @Column(name="signal_value")
    private String signalValue = null;
    @Basic
    @Column(name="log_token")
    private String logToken = null;
    @Basic
    @Column(name="sla_xml")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob slaXml;
    @Basic
    @Column(name="name")
    private String name = null;
    @Basic
    @Column(name="cred")
    private String cred = null;
    @Basic
    @Column(name="type")
    private String type = null;
    @Basic
    @Column(name="conf")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob conf;
    @Basic
    @Column(name="retries")
    private int retries;
    @Basic
    @Column(name="user_retry_count")
    private int userRetryCount;
    @Basic
    @Column(name="user_retry_max")
    private int userRetryMax;
    @Basic
    @Column(name="user_retry_interval")
    private int userRetryInterval;
    @Basic
    @Column(name="transition")
    private String transition = null;
    @Basic
    @Column(name="data")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob data;
    @Basic
    @Column(name="stats")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob stats;
    @Basic
    @Column(name="external_child_ids")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob externalChildIDs;
    @Basic
    @Column(name="external_id")
    private String externalId = null;
    @Basic
    @Column(name="external_status")
    private String externalStatus = null;
    @Basic
    @Column(name="tracker_uri")
    private String trackerUri = null;
    @Basic
    @Column(name="console_url")
    private String consoleUrl = null;
    @Basic
    @Column(name="error_code")
    private String errorCode = null;
    @Column(name="error_message", length=500)
    private String errorMessage = null;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Lorg$apache$oozie$StringBlob;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Lorg$apache$oozie$WorkflowActionBean;
    private transient Object pcDetachedState;

    public void write(DataOutput dataOutput) throws IOException {
        WritableUtils.writeStr(dataOutput, this.getId());
        WritableUtils.writeStr(dataOutput, this.getName());
        WritableUtils.writeStr(dataOutput, this.getCred());
        WritableUtils.writeStr(dataOutput, this.getType());
        WritableUtils.writeStr(dataOutput, this.getConf());
        WritableUtils.writeStr(dataOutput, this.getStatusStr());
        dataOutput.writeInt(this.getRetries());
        dataOutput.writeLong(this.getStartTime() != null ? this.getStartTime().getTime() : -1L);
        dataOutput.writeLong(this.getEndTime() != null ? this.getEndTime().getTime() : -1L);
        dataOutput.writeLong(this.getLastCheckTime() != null ? this.getLastCheckTime().getTime() : -1L);
        WritableUtils.writeStr(dataOutput, this.getTransition());
        WritableUtils.writeStr(dataOutput, this.getData());
        WritableUtils.writeStr(dataOutput, this.getStats());
        WritableUtils.writeStr(dataOutput, this.getExternalChildIDs());
        WritableUtils.writeStr(dataOutput, this.getExternalId());
        WritableUtils.writeStr(dataOutput, this.getExternalStatus());
        WritableUtils.writeStr(dataOutput, this.getTrackerUri());
        WritableUtils.writeStr(dataOutput, this.getConsoleUrl());
        WritableUtils.writeStr(dataOutput, this.getErrorCode());
        WritableUtils.writeStr(dataOutput, this.getErrorMessage());
        WritableUtils.writeStr(dataOutput, WorkflowActionBean.pcGetwfId(this));
        WritableUtils.writeStr(dataOutput, WorkflowActionBean.pcGetexecutionPath(this));
        dataOutput.writeInt(WorkflowActionBean.pcGetpending(this));
        dataOutput.writeLong(this.getPendingAge() != null ? this.getPendingAge().getTime() : -1L);
        WritableUtils.writeStr(dataOutput, WorkflowActionBean.pcGetsignalValue(this));
        WritableUtils.writeStr(dataOutput, WorkflowActionBean.pcGetlogToken(this));
        dataOutput.writeInt(this.getUserRetryCount());
        dataOutput.writeInt(this.getUserRetryInterval());
        dataOutput.writeInt(this.getUserRetryMax());
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.setId(WritableUtils.readStr(dataInput));
        this.setName(WritableUtils.readStr(dataInput));
        this.setCred(WritableUtils.readStr(dataInput));
        this.setType(WritableUtils.readStr(dataInput));
        this.setConf(WritableUtils.readStr(dataInput));
        this.setStatus(WorkflowAction.Status.valueOf((String)WritableUtils.readStr(dataInput)));
        this.setRetries(dataInput.readInt());
        long d = dataInput.readLong();
        if (d != -1L) {
            this.setStartTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setEndTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setLastCheckTime(new Date(d));
        }
        this.setTransition(WritableUtils.readStr(dataInput));
        this.setData(WritableUtils.readStr(dataInput));
        this.setStats(WritableUtils.readStr(dataInput));
        this.setExternalChildIDs(WritableUtils.readStr(dataInput));
        this.setExternalId(WritableUtils.readStr(dataInput));
        this.setExternalStatus(WritableUtils.readStr(dataInput));
        this.setTrackerUri(WritableUtils.readStr(dataInput));
        this.setConsoleUrl(WritableUtils.readStr(dataInput));
        this.setErrorInfo(WritableUtils.readStr(dataInput), WritableUtils.readStr(dataInput));
        WorkflowActionBean.pcSetwfId(this, WritableUtils.readStr(dataInput));
        WorkflowActionBean.pcSetexecutionPath(this, WritableUtils.readStr(dataInput));
        WorkflowActionBean.pcSetpending(this, dataInput.readInt());
        d = dataInput.readLong();
        if (d != -1L) {
            WorkflowActionBean.pcSetpendingAgeTimestamp(this, DateUtils.convertDateToTimestamp(new Date(d)));
        }
        WorkflowActionBean.pcSetsignalValue(this, WritableUtils.readStr(dataInput));
        WorkflowActionBean.pcSetlogToken(this, WritableUtils.readStr(dataInput));
        this.setUserRetryCount(dataInput.readInt());
        this.setUserRetryInterval(dataInput.readInt());
        this.setUserRetryMax(dataInput.readInt());
    }

    public boolean inTerminalState() {
        boolean isTerminalState = false;
        switch (WorkflowAction.Status.valueOf((String)WorkflowActionBean.pcGetstatusStr(this))) {
            case ERROR: 
            case FAILED: 
            case KILLED: 
            case OK: {
                isTerminalState = true;
                break;
            }
        }
        return isTerminalState;
    }

    public boolean isExecutionComplete() {
        return this.getStatus() == WorkflowAction.Status.DONE;
    }

    public boolean isRetryOrManual() {
        return this.getStatus() == WorkflowAction.Status.START_RETRY || this.getStatus() == WorkflowAction.Status.START_MANUAL || this.getStatus() == WorkflowAction.Status.END_RETRY || this.getStatus() == WorkflowAction.Status.END_MANUAL;
    }

    public boolean isUserRetry() {
        return this.getStatus() == WorkflowAction.Status.USER_RETRY;
    }

    public boolean isComplete() {
        return this.getStatus() == WorkflowAction.Status.OK || this.getStatus() == WorkflowAction.Status.KILLED || this.getStatus() == WorkflowAction.Status.ERROR;
    }

    public boolean isTerminalWithFailure() {
        boolean result = false;
        switch (this.getStatus()) {
            case ERROR: 
            case FAILED: 
            case KILLED: {
                result = true;
            }
        }
        return result;
    }

    public void setPendingOnly() {
        WorkflowActionBean.pcSetpending(this, 1);
    }

    public void setPending() {
        WorkflowActionBean.pcSetpending(this, 1);
        WorkflowActionBean.pcSetpendingAgeTimestamp(this, DateUtils.convertDateToTimestamp(new Date()));
    }

    public void setPending(int i) {
        WorkflowActionBean.pcSetpending(this, i);
    }

    public void setPendingAge(Date pendingAge) {
        WorkflowActionBean.pcSetpendingAgeTimestamp(this, DateUtils.convertDateToTimestamp(pendingAge));
    }

    public Date getPendingAge() {
        return DateUtils.toDate(WorkflowActionBean.pcGetpendingAgeTimestamp(this));
    }

    public boolean isPending() {
        return WorkflowActionBean.pcGetpending(this) == 1;
    }

    public void resetPending() {
        WorkflowActionBean.pcSetpending(this, 0);
        WorkflowActionBean.pcSetpendingAgeTimestamp(this, null);
    }

    public void resetPendingOnly() {
        WorkflowActionBean.pcSetpending(this, 0);
    }

    public void incRetries() {
        this.setRetries(this.getRetries() + 1);
    }

    public void setStartData(String externalId, String trackerUri, String consoleUrl) {
        this.setExternalId(ParamChecker.notEmpty(externalId, "externalId"));
        this.setTrackerUri(ParamChecker.notEmpty(trackerUri, "trackerUri"));
        this.setConsoleUrl(ParamChecker.notEmpty(consoleUrl, "consoleUrl"));
        Date now = new Date();
        if (WorkflowActionBean.pcGetstartTimestamp(this) == null) {
            this.setStartTime(now);
        }
        this.setLastCheckTime(now);
        this.setStatus(WorkflowAction.Status.RUNNING);
    }

    public void setExecutionData(String externalStatus, Properties actionData) {
        this.setStatus(WorkflowAction.Status.DONE);
        this.setExternalStatus(ParamChecker.notEmpty(externalStatus, "externalStatus"));
        if (actionData != null) {
            this.setData(PropertiesUtils.propertiesToString(actionData));
        }
    }

    public String getExecutionStats() {
        return this.getStats();
    }

    public void setExecutionStats(String jsonStats) {
        this.setStats(jsonStats);
    }

    public String getExternalChildIDs() {
        return WorkflowActionBean.pcGetexternalChildIDs(this) == null ? null : WorkflowActionBean.pcGetexternalChildIDs(this).getString();
    }

    public void setExternalChildIDs(String externalChildIDs) {
        if (WorkflowActionBean.pcGetexternalChildIDs(this) == null) {
            WorkflowActionBean.pcSetexternalChildIDs(this, new StringBlob(externalChildIDs));
        } else {
            WorkflowActionBean.pcGetexternalChildIDs(this).setString(externalChildIDs);
        }
    }

    public void setExternalChildIDsBlob(StringBlob externalChildIDs) {
        WorkflowActionBean.pcSetexternalChildIDs(this, externalChildIDs);
    }

    public StringBlob getExternalChildIDsBlob() {
        return WorkflowActionBean.pcGetexternalChildIDs(this);
    }

    public void setEndData(WorkflowAction.Status status, String signalValue) {
        if (status == null || status != WorkflowAction.Status.OK && status != WorkflowAction.Status.ERROR && status != WorkflowAction.Status.KILLED) {
            throw new IllegalArgumentException("Action status must be OK, ERROR or KILLED. Received [" + status.toString() + "]");
        }
        if (status == WorkflowAction.Status.OK) {
            this.setErrorInfo(null, null);
        }
        this.setStatus(status);
        this.setSignalValue(ParamChecker.notEmpty(signalValue, "signalValue"));
    }

    public String getJobId() {
        return WorkflowActionBean.pcGetwfId(this);
    }

    public String getWfId() {
        return WorkflowActionBean.pcGetwfId(this);
    }

    public void setJobId(String id) {
        WorkflowActionBean.pcSetwfId(this, id);
    }

    public void setSlaXml(String slaXmlStr) {
        if (WorkflowActionBean.pcGetslaXml(this) == null) {
            WorkflowActionBean.pcSetslaXml(this, new StringBlob(slaXmlStr));
        } else {
            WorkflowActionBean.pcGetslaXml(this).setString(slaXmlStr);
        }
    }

    public String getSlaXml() {
        return WorkflowActionBean.pcGetslaXml(this) == null ? null : WorkflowActionBean.pcGetslaXml(this).getString();
    }

    public void setSlaXmlBlob(StringBlob slaXml) {
        WorkflowActionBean.pcSetslaXml(this, slaXml);
    }

    public StringBlob getSlaXmlBlob() {
        return WorkflowActionBean.pcGetslaXml(this);
    }

    public void setStatus(WorkflowAction.Status val) {
        WorkflowActionBean.pcSetstatusStr(this, val.toString());
    }

    public WorkflowAction.Status getStatus() {
        return WorkflowAction.Status.valueOf((String)WorkflowActionBean.pcGetstatusStr(this));
    }

    public void setStatusStr(String statusStr) {
        WorkflowActionBean.pcSetstatusStr(this, statusStr);
    }

    public String getStatusStr() {
        return WorkflowActionBean.pcGetstatusStr(this);
    }

    public String getExecutionPath() {
        return WorkflowActionBean.pcGetexecutionPath(this);
    }

    public void setExecutionPath(String executionPath) {
        WorkflowActionBean.pcSetexecutionPath(this, executionPath);
    }

    public String getSignalValue() {
        return WorkflowActionBean.pcGetsignalValue(this);
    }

    public void setSignalValue(String signalValue) {
        WorkflowActionBean.pcSetsignalValue(this, signalValue);
    }

    public String getLogToken() {
        return WorkflowActionBean.pcGetlogToken(this);
    }

    public void setLogToken(String logToken) {
        WorkflowActionBean.pcSetlogToken(this, logToken);
    }

    public Date getLastCheckTime() {
        return DateUtils.toDate(WorkflowActionBean.pcGetlastCheckTimestamp(this));
    }

    public Timestamp getLastCheckTimestamp() {
        return WorkflowActionBean.pcGetlastCheckTimestamp(this);
    }

    public Timestamp getStartTimestamp() {
        return WorkflowActionBean.pcGetstartTimestamp(this);
    }

    public Timestamp getEndTimestamp() {
        return WorkflowActionBean.pcGetendTimestamp(this);
    }

    public Timestamp getPendingAgeTimestamp() {
        return WorkflowActionBean.pcGetpendingAgeTimestamp(this);
    }

    public void setLastCheckTime(Date lastCheckTime) {
        WorkflowActionBean.pcSetlastCheckTimestamp(this, DateUtils.convertDateToTimestamp(lastCheckTime));
    }

    public int getPending() {
        return WorkflowActionBean.pcGetpending(this);
    }

    public Date getStartTime() {
        return DateUtils.toDate(WorkflowActionBean.pcGetstartTimestamp(this));
    }

    public void setStartTime(Date startTime) {
        WorkflowActionBean.pcSetstartTimestamp(this, DateUtils.convertDateToTimestamp(startTime));
    }

    public Date getEndTime() {
        return DateUtils.toDate(WorkflowActionBean.pcGetendTimestamp(this));
    }

    public void setEndTime(Date endTime) {
        WorkflowActionBean.pcSetendTimestamp(this, DateUtils.convertDateToTimestamp(endTime));
    }

    @Override
    public JSONObject toJSONObject() {
        return this.toJSONObject("GMT");
    }

    @Override
    public JSONObject toJSONObject(String timeZoneId) {
        JSONObject json = new JSONObject();
        json.put((Object)"id", (Object)WorkflowActionBean.pcGetid(this));
        json.put((Object)"name", (Object)WorkflowActionBean.pcGetname(this));
        json.put((Object)"cred", (Object)WorkflowActionBean.pcGetcred(this));
        json.put((Object)"type", (Object)WorkflowActionBean.pcGettype(this));
        json.put((Object)"conf", (Object)this.getConf());
        json.put((Object)"status", (Object)WorkflowActionBean.pcGetstatusStr(this));
        json.put((Object)"retries", (Object)WorkflowActionBean.pcGetretries(this));
        json.put((Object)"startTime", (Object)JsonUtils.formatDateRfc822((Date)this.getStartTime(), (String)timeZoneId));
        json.put((Object)"endTime", (Object)JsonUtils.formatDateRfc822((Date)this.getEndTime(), (String)timeZoneId));
        json.put((Object)"transition", (Object)WorkflowActionBean.pcGettransition(this));
        json.put((Object)"data", (Object)this.getData());
        json.put((Object)"stats", (Object)this.getStats());
        json.put((Object)"externalChildIDs", (Object)this.getExternalChildIDs());
        json.put((Object)"externalId", (Object)WorkflowActionBean.pcGetexternalId(this));
        json.put((Object)"externalStatus", (Object)WorkflowActionBean.pcGetexternalStatus(this));
        json.put((Object)"trackerUri", (Object)WorkflowActionBean.pcGettrackerUri(this));
        json.put((Object)"consoleUrl", (Object)WorkflowActionBean.pcGetconsoleUrl(this));
        json.put((Object)"errorCode", (Object)WorkflowActionBean.pcGeterrorCode(this));
        json.put((Object)"errorMessage", (Object)WorkflowActionBean.pcGeterrorMessage(this));
        json.put((Object)"toString", (Object)this.toString());
        json.put((Object)"userRetryInterval", (Object)WorkflowActionBean.pcGetuserRetryInterval(this));
        json.put((Object)"userRetryCount", (Object)WorkflowActionBean.pcGetuserRetryCount(this));
        json.put((Object)"userRetryMax", (Object)WorkflowActionBean.pcGetuserRetryMax(this));
        json.put((Object)"cred", (Object)WorkflowActionBean.pcGetcred(this));
        return json;
    }

    public String getId() {
        return WorkflowActionBean.pcGetid(this);
    }

    public void setId(String id) {
        WorkflowActionBean.pcSetid(this, id);
    }

    public Timestamp getCreatedTimestamp() {
        return WorkflowActionBean.pcGetcreatedTimeTS(this);
    }

    public Date getCreatedTime() {
        return DateUtils.toDate(WorkflowActionBean.pcGetcreatedTimeTS(this));
    }

    public void setCreatedTime(Date createdTime) {
        WorkflowActionBean.pcSetcreatedTimeTS(this, DateUtils.convertDateToTimestamp(createdTime));
    }

    public String getName() {
        return WorkflowActionBean.pcGetname(this);
    }

    public void setName(String name) {
        WorkflowActionBean.pcSetname(this, name);
    }

    public String getCred() {
        return WorkflowActionBean.pcGetcred(this);
    }

    public void setCred(String cred) {
        WorkflowActionBean.pcSetcred(this, cred);
    }

    public String getType() {
        return WorkflowActionBean.pcGettype(this);
    }

    public void setType(String type) {
        WorkflowActionBean.pcSettype(this, type);
    }

    public String getConf() {
        return WorkflowActionBean.pcGetconf(this) == null ? null : WorkflowActionBean.pcGetconf(this).getString();
    }

    public void setConf(String conf) {
        if (WorkflowActionBean.pcGetconf(this) == null) {
            WorkflowActionBean.pcSetconf(this, new StringBlob(conf));
        } else {
            WorkflowActionBean.pcGetconf(this).setString(conf);
        }
    }

    public void setConfBlob(StringBlob conf) {
        WorkflowActionBean.pcSetconf(this, conf);
    }

    public StringBlob getConfBlob() {
        return WorkflowActionBean.pcGetconf(this);
    }

    public int getRetries() {
        return WorkflowActionBean.pcGetretries(this);
    }

    public void setRetries(int retries) {
        WorkflowActionBean.pcSetretries(this, retries);
    }

    public int getUserRetryCount() {
        return WorkflowActionBean.pcGetuserRetryCount(this);
    }

    public void setUserRetryCount(int retryCount) {
        WorkflowActionBean.pcSetuserRetryCount(this, retryCount);
    }

    public void incrmentUserRetryCount() {
        WorkflowActionBean workflowActionBean = this;
        WorkflowActionBean.pcSetuserRetryCount(workflowActionBean, WorkflowActionBean.pcGetuserRetryCount(workflowActionBean) + 1);
    }

    public int getUserRetryMax() {
        return WorkflowActionBean.pcGetuserRetryMax(this);
    }

    public void setUserRetryMax(int retryMax) {
        WorkflowActionBean.pcSetuserRetryMax(this, retryMax);
    }

    public int getUserRetryInterval() {
        return WorkflowActionBean.pcGetuserRetryInterval(this);
    }

    public void setUserRetryInterval(int retryInterval) {
        WorkflowActionBean.pcSetuserRetryInterval(this, retryInterval);
    }

    public String getTransition() {
        return WorkflowActionBean.pcGettransition(this);
    }

    public void setTransition(String transition) {
        WorkflowActionBean.pcSettransition(this, transition);
    }

    public String getData() {
        return WorkflowActionBean.pcGetdata(this) == null ? null : WorkflowActionBean.pcGetdata(this).getString();
    }

    public void setData(String data) {
        if (WorkflowActionBean.pcGetdata(this) == null) {
            WorkflowActionBean.pcSetdata(this, new StringBlob(data));
        } else {
            WorkflowActionBean.pcGetdata(this).setString(data);
        }
    }

    public void setDataBlob(StringBlob data) {
        WorkflowActionBean.pcSetdata(this, data);
    }

    public StringBlob getDataBlob() {
        return WorkflowActionBean.pcGetdata(this);
    }

    public String getStats() {
        return WorkflowActionBean.pcGetstats(this) == null ? null : WorkflowActionBean.pcGetstats(this).getString();
    }

    public void setStats(String stats) {
        if (WorkflowActionBean.pcGetstats(this) == null) {
            WorkflowActionBean.pcSetstats(this, new StringBlob(stats));
        } else {
            WorkflowActionBean.pcGetstats(this).setString(stats);
        }
    }

    public void setStatsBlob(StringBlob stats) {
        WorkflowActionBean.pcSetstats(this, stats);
    }

    public StringBlob getStatsBlob() {
        return WorkflowActionBean.pcGetstats(this);
    }

    public String getExternalId() {
        return WorkflowActionBean.pcGetexternalId(this);
    }

    public void setExternalId(String externalId) {
        WorkflowActionBean.pcSetexternalId(this, externalId);
    }

    public String getExternalStatus() {
        return WorkflowActionBean.pcGetexternalStatus(this);
    }

    public void setExternalStatus(String externalStatus) {
        WorkflowActionBean.pcSetexternalStatus(this, externalStatus);
    }

    public String getTrackerUri() {
        return WorkflowActionBean.pcGettrackerUri(this);
    }

    public void setTrackerUri(String trackerUri) {
        WorkflowActionBean.pcSettrackerUri(this, trackerUri);
    }

    public String getConsoleUrl() {
        return WorkflowActionBean.pcGetconsoleUrl(this);
    }

    public void setConsoleUrl(String consoleUrl) {
        WorkflowActionBean.pcSetconsoleUrl(this, consoleUrl);
    }

    public String getErrorCode() {
        return WorkflowActionBean.pcGeterrorCode(this);
    }

    public String getErrorMessage() {
        return WorkflowActionBean.pcGeterrorMessage(this);
    }

    public void setErrorInfo(String errorCode, String errorMessage) {
        WorkflowActionBean.pcSeterrorCode(this, errorCode);
        if (errorMessage != null && errorMessage.length() > 500) {
            errorMessage = errorMessage.substring(0, 500);
        }
        WorkflowActionBean.pcSeterrorMessage(this, errorMessage);
    }

    public String toString() {
        return MessageFormat.format("Action name[{0}] status[{1}]", this.getName(), this.getStatus());
    }

    public static JSONArray toJSONArray(List<WorkflowActionBean> nodes, String timeZoneId) {
        JSONArray array = new JSONArray();
        for (WorkflowActionBean node : nodes) {
            array.add((Object)node.toJSONObject(timeZoneId));
        }
        return array;
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"conf", "consoleUrl", "createdTimeTS", "cred", "data", "endTimestamp", "errorCode", "errorMessage", "executionPath", "externalChildIDs", "externalId", "externalStatus", "id", "lastCheckTimestamp", "logToken", "name", "pending", "pendingAgeTimestamp", "retries", "signalValue", "slaXml", "startTimestamp", "stats", "statusStr", "trackerUri", "transition", "type", "userRetryCount", "userRetryInterval", "userRetryMax", "wfId"};
        Class[] classArray = new Class[31];
        Class clazz = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = WorkflowActionBean.class$("org.apache.oozie.StringBlob"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[1] = clazz2;
        Class clazz3 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowActionBean.class$("java.sql.Timestamp"));
        classArray[2] = clazz3;
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[4] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = WorkflowActionBean.class$("org.apache.oozie.StringBlob"));
        classArray[5] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowActionBean.class$("java.sql.Timestamp"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[9] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = WorkflowActionBean.class$("org.apache.oozie.StringBlob"));
        classArray[10] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[11] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[13] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowActionBean.class$("java.sql.Timestamp"));
        classArray[14] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[16] = Integer.TYPE;
        classArray[17] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowActionBean.class$("java.sql.Timestamp"));
        classArray[18] = Integer.TYPE;
        classArray[19] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[20] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = WorkflowActionBean.class$("org.apache.oozie.StringBlob"));
        classArray[21] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowActionBean.class$("java.sql.Timestamp"));
        classArray[22] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = WorkflowActionBean.class$("org.apache.oozie.StringBlob"));
        classArray[23] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[24] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[25] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[26] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[27] = Integer.TYPE;
        classArray[28] = Integer.TYPE;
        classArray[29] = Integer.TYPE;
        classArray[30] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{10, 26, 26, 26, 10, 26, 26, 26, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 10, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz4 = class$Lorg$apache$oozie$WorkflowActionBean != null ? class$Lorg$apache$oozie$WorkflowActionBean : (class$Lorg$apache$oozie$WorkflowActionBean = WorkflowActionBean.class$("org.apache.oozie.WorkflowActionBean"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"WorkflowActionBean", (PersistenceCapable)new WorkflowActionBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.conf = null;
        this.consoleUrl = null;
        this.createdTimeTS = null;
        this.cred = null;
        this.data = null;
        this.endTimestamp = null;
        this.errorCode = null;
        this.errorMessage = null;
        this.executionPath = null;
        this.externalChildIDs = null;
        this.externalId = null;
        this.externalStatus = null;
        this.id = null;
        this.lastCheckTimestamp = null;
        this.logToken = null;
        this.name = null;
        this.pending = 0;
        this.pendingAgeTimestamp = null;
        this.retries = 0;
        this.signalValue = null;
        this.slaXml = null;
        this.startTimestamp = null;
        this.stats = null;
        this.statusStr = null;
        this.trackerUri = null;
        this.transition = null;
        this.type = null;
        this.userRetryCount = 0;
        this.userRetryInterval = 0;
        this.userRetryMax = 0;
        this.wfId = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        WorkflowActionBean workflowActionBean = new WorkflowActionBean();
        if (bl) {
            workflowActionBean.pcClearFields();
        }
        workflowActionBean.pcStateManager = stateManager;
        workflowActionBean.pcCopyKeyFieldsFromObjectId(object);
        return workflowActionBean;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        WorkflowActionBean workflowActionBean = new WorkflowActionBean();
        if (bl) {
            workflowActionBean.pcClearFields();
        }
        workflowActionBean.pcStateManager = stateManager;
        return workflowActionBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 31;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.conf = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.consoleUrl = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.createdTimeTS = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.cred = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.data = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.endTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.errorCode = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.errorMessage = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.executionPath = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.externalChildIDs = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.externalStatus = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.id = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.lastCheckTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.logToken = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.pending = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.pendingAgeTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.retries = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.signalValue = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.slaXml = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.startTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 22: {
                this.stats = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 23: {
                this.statusStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 24: {
                this.trackerUri = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 25: {
                this.transition = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 26: {
                this.type = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 27: {
                this.userRetryCount = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 28: {
                this.userRetryInterval = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 29: {
                this.userRetryMax = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 30: {
                this.wfId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.conf);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.consoleUrl);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createdTimeTS);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.cred);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.data);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.endTimestamp);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.errorCode);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.errorMessage);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.executionPath);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.externalChildIDs);
                return;
            }
            case 10: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalStatus);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastCheckTimestamp);
                return;
            }
            case 14: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.logToken);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 16: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.pending);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pendingAgeTimestamp);
                return;
            }
            case 18: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.retries);
                return;
            }
            case 19: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.signalValue);
                return;
            }
            case 20: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.slaXml);
                return;
            }
            case 21: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.startTimestamp);
                return;
            }
            case 22: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.stats);
                return;
            }
            case 23: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.statusStr);
                return;
            }
            case 24: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.trackerUri);
                return;
            }
            case 25: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.transition);
                return;
            }
            case 26: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.type);
                return;
            }
            case 27: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.userRetryCount);
                return;
            }
            case 28: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.userRetryInterval);
                return;
            }
            case 29: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.userRetryMax);
                return;
            }
            case 30: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.wfId);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(WorkflowActionBean workflowActionBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.conf = workflowActionBean.conf;
                return;
            }
            case 1: {
                this.consoleUrl = workflowActionBean.consoleUrl;
                return;
            }
            case 2: {
                this.createdTimeTS = workflowActionBean.createdTimeTS;
                return;
            }
            case 3: {
                this.cred = workflowActionBean.cred;
                return;
            }
            case 4: {
                this.data = workflowActionBean.data;
                return;
            }
            case 5: {
                this.endTimestamp = workflowActionBean.endTimestamp;
                return;
            }
            case 6: {
                this.errorCode = workflowActionBean.errorCode;
                return;
            }
            case 7: {
                this.errorMessage = workflowActionBean.errorMessage;
                return;
            }
            case 8: {
                this.executionPath = workflowActionBean.executionPath;
                return;
            }
            case 9: {
                this.externalChildIDs = workflowActionBean.externalChildIDs;
                return;
            }
            case 10: {
                this.externalId = workflowActionBean.externalId;
                return;
            }
            case 11: {
                this.externalStatus = workflowActionBean.externalStatus;
                return;
            }
            case 12: {
                this.id = workflowActionBean.id;
                return;
            }
            case 13: {
                this.lastCheckTimestamp = workflowActionBean.lastCheckTimestamp;
                return;
            }
            case 14: {
                this.logToken = workflowActionBean.logToken;
                return;
            }
            case 15: {
                this.name = workflowActionBean.name;
                return;
            }
            case 16: {
                this.pending = workflowActionBean.pending;
                return;
            }
            case 17: {
                this.pendingAgeTimestamp = workflowActionBean.pendingAgeTimestamp;
                return;
            }
            case 18: {
                this.retries = workflowActionBean.retries;
                return;
            }
            case 19: {
                this.signalValue = workflowActionBean.signalValue;
                return;
            }
            case 20: {
                this.slaXml = workflowActionBean.slaXml;
                return;
            }
            case 21: {
                this.startTimestamp = workflowActionBean.startTimestamp;
                return;
            }
            case 22: {
                this.stats = workflowActionBean.stats;
                return;
            }
            case 23: {
                this.statusStr = workflowActionBean.statusStr;
                return;
            }
            case 24: {
                this.trackerUri = workflowActionBean.trackerUri;
                return;
            }
            case 25: {
                this.transition = workflowActionBean.transition;
                return;
            }
            case 26: {
                this.type = workflowActionBean.type;
                return;
            }
            case 27: {
                this.userRetryCount = workflowActionBean.userRetryCount;
                return;
            }
            case 28: {
                this.userRetryInterval = workflowActionBean.userRetryInterval;
                return;
            }
            case 29: {
                this.userRetryMax = workflowActionBean.userRetryMax;
                return;
            }
            case 30: {
                this.wfId = workflowActionBean.wfId;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        WorkflowActionBean workflowActionBean = (WorkflowActionBean)object;
        if (workflowActionBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(workflowActionBean, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(12 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.id = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$oozie$WorkflowActionBean != null ? class$Lorg$apache$oozie$WorkflowActionBean : (class$Lorg$apache$oozie$WorkflowActionBean = WorkflowActionBean.class$("org.apache.oozie.WorkflowActionBean"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$oozie$WorkflowActionBean != null ? class$Lorg$apache$oozie$WorkflowActionBean : (class$Lorg$apache$oozie$WorkflowActionBean = WorkflowActionBean.class$("org.apache.oozie.WorkflowActionBean"));
        return new StringId(clazz, this.id);
    }

    private static final StringBlob pcGetconf(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.conf;
        }
        int n = pcInheritedFieldCount + 0;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.conf;
    }

    private static final void pcSetconf(WorkflowActionBean workflowActionBean, StringBlob stringBlob) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.conf = stringBlob;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 0, (Object)workflowActionBean.conf, (Object)stringBlob, 0);
    }

    private static final String pcGetconsoleUrl(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.consoleUrl;
        }
        int n = pcInheritedFieldCount + 1;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.consoleUrl;
    }

    private static final void pcSetconsoleUrl(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.consoleUrl = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 1, workflowActionBean.consoleUrl, string, 0);
    }

    private static final Timestamp pcGetcreatedTimeTS(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.createdTimeTS;
        }
        int n = pcInheritedFieldCount + 2;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.createdTimeTS;
    }

    private static final void pcSetcreatedTimeTS(WorkflowActionBean workflowActionBean, Timestamp timestamp) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.createdTimeTS = timestamp;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 2, (Object)workflowActionBean.createdTimeTS, (Object)timestamp, 0);
    }

    private static final String pcGetcred(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.cred;
        }
        int n = pcInheritedFieldCount + 3;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.cred;
    }

    private static final void pcSetcred(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.cred = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 3, workflowActionBean.cred, string, 0);
    }

    private static final StringBlob pcGetdata(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.data;
        }
        int n = pcInheritedFieldCount + 4;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.data;
    }

    private static final void pcSetdata(WorkflowActionBean workflowActionBean, StringBlob stringBlob) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.data = stringBlob;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 4, (Object)workflowActionBean.data, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetendTimestamp(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.endTimestamp;
        }
        int n = pcInheritedFieldCount + 5;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.endTimestamp;
    }

    private static final void pcSetendTimestamp(WorkflowActionBean workflowActionBean, Timestamp timestamp) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.endTimestamp = timestamp;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 5, (Object)workflowActionBean.endTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGeterrorCode(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.errorCode;
        }
        int n = pcInheritedFieldCount + 6;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.errorCode;
    }

    private static final void pcSeterrorCode(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.errorCode = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 6, workflowActionBean.errorCode, string, 0);
    }

    private static final String pcGeterrorMessage(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.errorMessage;
        }
        int n = pcInheritedFieldCount + 7;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.errorMessage;
    }

    private static final void pcSeterrorMessage(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.errorMessage = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 7, workflowActionBean.errorMessage, string, 0);
    }

    private static final String pcGetexecutionPath(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.executionPath;
        }
        int n = pcInheritedFieldCount + 8;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.executionPath;
    }

    private static final void pcSetexecutionPath(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.executionPath = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 8, workflowActionBean.executionPath, string, 0);
    }

    private static final StringBlob pcGetexternalChildIDs(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.externalChildIDs;
        }
        int n = pcInheritedFieldCount + 9;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.externalChildIDs;
    }

    private static final void pcSetexternalChildIDs(WorkflowActionBean workflowActionBean, StringBlob stringBlob) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.externalChildIDs = stringBlob;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 9, (Object)workflowActionBean.externalChildIDs, (Object)stringBlob, 0);
    }

    private static final String pcGetexternalId(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.externalId;
        }
        int n = pcInheritedFieldCount + 10;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.externalId;
    }

    private static final void pcSetexternalId(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.externalId = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 10, workflowActionBean.externalId, string, 0);
    }

    private static final String pcGetexternalStatus(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.externalStatus;
        }
        int n = pcInheritedFieldCount + 11;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.externalStatus;
    }

    private static final void pcSetexternalStatus(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.externalStatus = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 11, workflowActionBean.externalStatus, string, 0);
    }

    private static final String pcGetid(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.id;
        }
        int n = pcInheritedFieldCount + 12;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.id;
    }

    private static final void pcSetid(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.id = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 12, workflowActionBean.id, string, 0);
    }

    private static final Timestamp pcGetlastCheckTimestamp(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.lastCheckTimestamp;
        }
        int n = pcInheritedFieldCount + 13;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.lastCheckTimestamp;
    }

    private static final void pcSetlastCheckTimestamp(WorkflowActionBean workflowActionBean, Timestamp timestamp) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.lastCheckTimestamp = timestamp;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 13, (Object)workflowActionBean.lastCheckTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetlogToken(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.logToken;
        }
        int n = pcInheritedFieldCount + 14;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.logToken;
    }

    private static final void pcSetlogToken(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.logToken = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 14, workflowActionBean.logToken, string, 0);
    }

    private static final String pcGetname(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.name;
        }
        int n = pcInheritedFieldCount + 15;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.name;
    }

    private static final void pcSetname(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.name = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 15, workflowActionBean.name, string, 0);
    }

    private static final int pcGetpending(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.pending;
        }
        int n = pcInheritedFieldCount + 16;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.pending;
    }

    private static final void pcSetpending(WorkflowActionBean workflowActionBean, int n) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.pending = n;
            return;
        }
        workflowActionBean.pcStateManager.settingIntField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 16, workflowActionBean.pending, n, 0);
    }

    private static final Timestamp pcGetpendingAgeTimestamp(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.pendingAgeTimestamp;
        }
        int n = pcInheritedFieldCount + 17;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.pendingAgeTimestamp;
    }

    private static final void pcSetpendingAgeTimestamp(WorkflowActionBean workflowActionBean, Timestamp timestamp) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.pendingAgeTimestamp = timestamp;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 17, (Object)workflowActionBean.pendingAgeTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGetretries(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.retries;
        }
        int n = pcInheritedFieldCount + 18;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.retries;
    }

    private static final void pcSetretries(WorkflowActionBean workflowActionBean, int n) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.retries = n;
            return;
        }
        workflowActionBean.pcStateManager.settingIntField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 18, workflowActionBean.retries, n, 0);
    }

    private static final String pcGetsignalValue(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.signalValue;
        }
        int n = pcInheritedFieldCount + 19;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.signalValue;
    }

    private static final void pcSetsignalValue(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.signalValue = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 19, workflowActionBean.signalValue, string, 0);
    }

    private static final StringBlob pcGetslaXml(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.slaXml;
        }
        int n = pcInheritedFieldCount + 20;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.slaXml;
    }

    private static final void pcSetslaXml(WorkflowActionBean workflowActionBean, StringBlob stringBlob) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.slaXml = stringBlob;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 20, (Object)workflowActionBean.slaXml, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetstartTimestamp(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.startTimestamp;
        }
        int n = pcInheritedFieldCount + 21;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.startTimestamp;
    }

    private static final void pcSetstartTimestamp(WorkflowActionBean workflowActionBean, Timestamp timestamp) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.startTimestamp = timestamp;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 21, (Object)workflowActionBean.startTimestamp, (Object)timestamp, 0);
    }

    private static final StringBlob pcGetstats(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.stats;
        }
        int n = pcInheritedFieldCount + 22;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.stats;
    }

    private static final void pcSetstats(WorkflowActionBean workflowActionBean, StringBlob stringBlob) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.stats = stringBlob;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 22, (Object)workflowActionBean.stats, (Object)stringBlob, 0);
    }

    private static final String pcGetstatusStr(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.statusStr;
        }
        int n = pcInheritedFieldCount + 23;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.statusStr;
    }

    private static final void pcSetstatusStr(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.statusStr = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 23, workflowActionBean.statusStr, string, 0);
    }

    private static final String pcGettrackerUri(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.trackerUri;
        }
        int n = pcInheritedFieldCount + 24;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.trackerUri;
    }

    private static final void pcSettrackerUri(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.trackerUri = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 24, workflowActionBean.trackerUri, string, 0);
    }

    private static final String pcGettransition(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.transition;
        }
        int n = pcInheritedFieldCount + 25;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.transition;
    }

    private static final void pcSettransition(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.transition = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 25, workflowActionBean.transition, string, 0);
    }

    private static final String pcGettype(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.type;
        }
        int n = pcInheritedFieldCount + 26;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.type;
    }

    private static final void pcSettype(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.type = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 26, workflowActionBean.type, string, 0);
    }

    private static final int pcGetuserRetryCount(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.userRetryCount;
        }
        int n = pcInheritedFieldCount + 27;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.userRetryCount;
    }

    private static final void pcSetuserRetryCount(WorkflowActionBean workflowActionBean, int n) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.userRetryCount = n;
            return;
        }
        workflowActionBean.pcStateManager.settingIntField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 27, workflowActionBean.userRetryCount, n, 0);
    }

    private static final int pcGetuserRetryInterval(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.userRetryInterval;
        }
        int n = pcInheritedFieldCount + 28;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.userRetryInterval;
    }

    private static final void pcSetuserRetryInterval(WorkflowActionBean workflowActionBean, int n) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.userRetryInterval = n;
            return;
        }
        workflowActionBean.pcStateManager.settingIntField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 28, workflowActionBean.userRetryInterval, n, 0);
    }

    private static final int pcGetuserRetryMax(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.userRetryMax;
        }
        int n = pcInheritedFieldCount + 29;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.userRetryMax;
    }

    private static final void pcSetuserRetryMax(WorkflowActionBean workflowActionBean, int n) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.userRetryMax = n;
            return;
        }
        workflowActionBean.pcStateManager.settingIntField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 29, workflowActionBean.userRetryMax, n, 0);
    }

    private static final String pcGetwfId(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.wfId;
        }
        int n = pcInheritedFieldCount + 30;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.wfId;
    }

    private static final void pcSetwfId(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.wfId = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 30, workflowActionBean.wfId, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

