/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionReadyXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetForExternalIdJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordinatorJobGetForUserAppnameJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.db.SLADbOperations;

public class CoordActionUpdateXCommand
extends CoordinatorXCommand<Void> {
    private WorkflowJobBean workflow;
    private CoordinatorActionBean coordAction = null;
    private CoordinatorJobBean coordJob;
    private JPAService jpaService = null;
    private int maxRetries = 1;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    private List<JsonBean> insertList = new ArrayList<JsonBean>();

    public CoordActionUpdateXCommand(WorkflowJobBean workflow) {
        super("coord-action-update", "coord-action-update", 1);
        this.workflow = workflow;
    }

    public CoordActionUpdateXCommand(WorkflowJobBean workflow, int maxRetries) {
        super("coord-action-update", "coord-action-update", 1);
        this.workflow = workflow;
        this.maxRetries = maxRetries;
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.workflow.getId());
    }

    @Override
    protected Void execute() throws CommandException {
        try {
            SLAEventBean slaEvent;
            this.LOG.debug("STARTED CoordActionUpdateXCommand for wfId=[{0}]", this.workflow.getId());
            CoordinatorAction.Status formerCoordinatorStatus = this.coordAction.getStatus();
            int formerCoordinatorPending = this.coordAction.getPending();
            SLAEvent.Status slaStatus = null;
            if (this.workflow.getStatus() == WorkflowJob.Status.SUCCEEDED) {
                this.coordAction.setStatus(CoordinatorAction.Status.SUCCEEDED);
                this.coordAction.setPending(0);
                slaStatus = SLAEvent.Status.SUCCEEDED;
            } else if (this.workflow.getStatus() == WorkflowJob.Status.FAILED) {
                this.coordAction.setStatus(CoordinatorAction.Status.FAILED);
                this.coordAction.setPending(0);
                slaStatus = SLAEvent.Status.FAILED;
            } else if (this.workflow.getStatus() == WorkflowJob.Status.KILLED) {
                this.coordAction.setStatus(CoordinatorAction.Status.KILLED);
                this.coordAction.setPending(0);
                slaStatus = SLAEvent.Status.KILLED;
            } else if (this.workflow.getStatus() == WorkflowJob.Status.SUSPENDED) {
                this.coordAction.setStatus(CoordinatorAction.Status.SUSPENDED);
                this.coordAction.decrementAndGetPending();
            } else if (this.workflow.getStatus() == WorkflowJob.Status.RUNNING || this.workflow.getStatus() == WorkflowJob.Status.PREP) {
                this.coordAction.setStatus(CoordinatorAction.Status.RUNNING);
                this.coordAction.decrementAndGetPending();
            } else {
                this.LOG.warn("Unexpected workflow [{0}] STATUS [{1}]", this.workflow.getId(), this.workflow.getStatus());
                this.coordAction.setLastModifiedTime(new Date());
                CoordActionQueryExecutor.getInstance().executeUpdate(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_MODIFIED_DATE, this.coordAction);
                return null;
            }
            this.LOG.info("Updating Coordinator action id: [{0}] status [{1}] to [{2}] pending [{3}] to [{4}]", this.coordAction.getId(), formerCoordinatorStatus, this.coordAction.getStatus(), formerCoordinatorPending, this.coordAction.getPending());
            this.coordAction.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordActionQueryExecutor.CoordActionQuery>(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, this.coordAction));
            if (slaStatus != null && (slaEvent = SLADbOperations.createStatusEvent(this.coordAction.getSlaXml(), this.coordAction.getId(), slaStatus, SLAEvent.SlaAppType.COORDINATOR_ACTION, this.LOG)) != null) {
                this.insertList.add(slaEvent);
            }
            if (this.workflow.getStatus() != WorkflowJob.Status.SUSPENDED && this.workflow.getStatus() != WorkflowJob.Status.RUNNING) {
                this.queue(new CoordActionReadyXCommand(this.coordAction.getJobId()));
            }
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
            if (EventHandlerService.isEnabled()) {
                CoordActionUpdateXCommand.generateEvent(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName(), this.workflow.getStartTime());
            }
            this.LOG.debug("ENDED CoordActionUpdateXCommand for wfId= [{0}]", this.workflow.getId());
        }
        catch (XException ex) {
            this.LOG.warn("CoordActionUpdate Failed [{0}]", ex.getMessage());
            throw new CommandException(ex);
        }
        return null;
    }

    @Override
    public String getEntityKey() {
        return this.workflow.getParentId().substring(0, this.workflow.getParentId().indexOf("@"));
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        int retries = 0;
        while (retries++ < this.maxRetries) {
            try {
                this.coordAction = this.jpaService.execute(new CoordActionGetForExternalIdJPAExecutor(this.workflow.getId()));
                if (this.coordAction != null) {
                    this.coordJob = this.jpaService.execute(new CoordinatorJobGetForUserAppnameJPAExecutor(this.coordAction.getJobId()));
                    LogUtils.setLogInfo(this.coordAction);
                    break;
                }
                if (retries >= this.maxRetries) continue;
                Thread.sleep(500L);
            }
            catch (JPAExecutorException je) {
                this.LOG.warn("Could not load coord action {0}", je.getMessage(), je);
            }
            catch (InterruptedException ex) {
                this.LOG.warn("Retry to load coord action is interrupted {0}", ex.getMessage(), ex);
            }
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if ((this.workflow.getStatus() == WorkflowJob.Status.SUCCEEDED && this.coordAction.getStatus() == CoordinatorAction.Status.SUCCEEDED || this.workflow.getStatus() == WorkflowJob.Status.FAILED && this.coordAction.getStatus() == CoordinatorAction.Status.FAILED || this.workflow.getStatus() == WorkflowJob.Status.KILLED && this.coordAction.getStatus() == CoordinatorAction.Status.KILLED || this.workflow.getStatus() == WorkflowJob.Status.SUSPENDED && this.coordAction.getStatus() == CoordinatorAction.Status.SUSPENDED || this.workflow.getStatus() == WorkflowJob.Status.RUNNING && this.coordAction.getStatus() == CoordinatorAction.Status.RUNNING) && !this.coordAction.isPending()) {
            try {
                CoordActionQueryExecutor.getInstance().executeUpdate(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, this.coordAction);
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
            throw new PreconditionException(ErrorCode.E1100, ", workflow is " + this.workflow.getStatus() + " and coordinator action is " + this.coordAction.getStatus() + " and pending false");
        }
    }
}

