/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.protobuf.generated.CellProtos;
import org.apache.hadoop.hbase.types.PBType;
import org.apache.hadoop.hbase.util.PositionedByteRange;

public class PBCell
extends PBType<CellProtos.Cell> {
    public Class<CellProtos.Cell> encodedClass() {
        return CellProtos.Cell.class;
    }

    public int skip(PositionedByteRange src) {
        CellProtos.Cell.Builder builder = CellProtos.Cell.newBuilder();
        CodedInputStream is = PBCell.inputStreamFromByteRange((PositionedByteRange)src);
        is.setSizeLimit(src.getLength());
        try {
            builder.mergeFrom(is);
            int consumed = is.getTotalBytesRead();
            src.setPosition(src.getPosition() + consumed);
            return consumed;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while skipping type.", e);
        }
    }

    public CellProtos.Cell decode(PositionedByteRange src) {
        CellProtos.Cell.Builder builder = CellProtos.Cell.newBuilder();
        CodedInputStream is = PBCell.inputStreamFromByteRange((PositionedByteRange)src);
        is.setSizeLimit(src.getLength());
        try {
            CellProtos.Cell ret = ((CellProtos.Cell.Builder)builder.mergeFrom(is)).build();
            src.setPosition(src.getPosition() + is.getTotalBytesRead());
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while decoding type.", e);
        }
    }

    public int encode(PositionedByteRange dst, CellProtos.Cell val) {
        CodedOutputStream os = PBCell.outputStreamFromByteRange((PositionedByteRange)dst);
        try {
            int before = os.spaceLeft();
            val.writeTo(os);
            int after = os.spaceLeft();
            int written = before - after;
            dst.setPosition(dst.getPosition() + written);
            return written;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while encoding type.", e);
        }
    }
}

