/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Registration;
import javax.servlet.ServletContext;
import javax.servlet.UnavailableException;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Holder<T>
extends AbstractLifeCycle
implements Dumpable {
    private final Source _source;
    private static final Logger LOG = Log.getLogger(Holder.class);
    protected transient Class<? extends T> _class;
    protected final Map<String, String> _initParams = new HashMap<String, String>(3);
    protected String _className;
    protected String _displayName;
    protected boolean _extInstance;
    protected boolean _asyncSupported;
    protected String _name;
    protected ServletHandler _servletHandler;

    protected Holder(Source source) {
        this._source = source;
        switch (this._source) {
            case JAVAX_API: 
            case DESCRIPTOR: 
            case ANNOTATION: {
                this._asyncSupported = false;
                break;
            }
            default: {
                this._asyncSupported = true;
            }
        }
    }

    public Source getSource() {
        return this._source;
    }

    public boolean isInstance() {
        return this._extInstance;
    }

    public void doStart() throws Exception {
        if (this._class == null && (this._className == null || this._className.equals(""))) {
            throw new UnavailableException("No class for Servlet or Filter for " + this._name);
        }
        if (this._class == null) {
            try {
                this._class = Loader.loadClass(Holder.class, (String)this._className);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Holding {}", new Object[]{this._class});
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                throw new UnavailableException(e.getMessage());
            }
        }
    }

    public void doStop() throws Exception {
        if (!this._extInstance) {
            this._class = null;
        }
    }

    public String getClassName() {
        return this._className;
    }

    public Class<? extends T> getHeldClass() {
        return this._class;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getInitParameter(String param) {
        if (this._initParams == null) {
            return null;
        }
        return this._initParams.get(param);
    }

    public Enumeration getInitParameterNames() {
        if (this._initParams == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this._initParams.keySet());
    }

    public Map<String, String> getInitParameters() {
        return this._initParams;
    }

    public String getName() {
        return this._name;
    }

    public ServletHandler getServletHandler() {
        return this._servletHandler;
    }

    public void destroyInstance(Object instance) throws Exception {
    }

    public void setClassName(String className) {
        this._className = className;
        this._class = null;
        if (this._name == null) {
            this._name = className + "-" + Integer.toHexString(((Object)((Object)this)).hashCode());
        }
    }

    public void setHeldClass(Class<? extends T> held) {
        this._class = held;
        if (held != null) {
            this._className = held.getName();
            if (this._name == null) {
                this._name = held.getName() + "-" + Integer.toHexString(((Object)((Object)this)).hashCode());
            }
        }
    }

    public void setDisplayName(String name) {
        this._displayName = name;
    }

    public void setInitParameter(String param, String value) {
        this._initParams.put(param, value);
    }

    public void setInitParameters(Map<String, String> map) {
        this._initParams.clear();
        this._initParams.putAll(map);
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setServletHandler(ServletHandler servletHandler) {
        this._servletHandler = servletHandler;
    }

    public void setAsyncSupported(boolean suspendable) {
        this._asyncSupported = suspendable;
    }

    public boolean isAsyncSupported() {
        return this._asyncSupported;
    }

    public String toString() {
        return this._name;
    }

    protected void illegalStateIfContextStarted() {
        ContextHandler.Context context;
        if (this._servletHandler != null && (context = (ContextHandler.Context)this._servletHandler.getServletContext()) != null && context.getContextHandler().isStarted()) {
            throw new IllegalStateException("Started");
        }
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(this._name).append("==").append(this._className).append(" - ").append(AbstractLifeCycle.getState((LifeCycle)this)).append("\n");
        AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{this._initParams.entrySet()});
    }

    public String dump() {
        return AggregateLifeCycle.dump((Dumpable)this);
    }

    protected class HolderRegistration
    implements Registration.Dynamic {
        protected HolderRegistration() {
        }

        public void setAsyncSupported(boolean isAsyncSupported) {
            Holder.this.illegalStateIfContextStarted();
            Holder.this.setAsyncSupported(isAsyncSupported);
        }

        public void setDescription(String description) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " is " + description, new Object[0]);
            }
        }

        public String getClassName() {
            return Holder.this.getClassName();
        }

        public String getInitParameter(String name) {
            return Holder.this.getInitParameter(name);
        }

        public Map<String, String> getInitParameters() {
            return Holder.this.getInitParameters();
        }

        public String getName() {
            return Holder.this.getName();
        }

        public boolean setInitParameter(String name, String value) {
            Holder.this.illegalStateIfContextStarted();
            if (name == null) {
                throw new IllegalArgumentException("init parameter name required");
            }
            if (value == null) {
                throw new IllegalArgumentException("non-null value required for init parameter " + name);
            }
            if (Holder.this.getInitParameter(name) != null) {
                return false;
            }
            Holder.this.setInitParameter(name, value);
            return true;
        }

        public Set<String> setInitParameters(Map<String, String> initParameters) {
            Holder.this.illegalStateIfContextStarted();
            HashSet<String> clash = null;
            for (Map.Entry<String, String> entry : initParameters.entrySet()) {
                if (entry.getKey() == null) {
                    throw new IllegalArgumentException("init parameter name required");
                }
                if (entry.getValue() == null) {
                    throw new IllegalArgumentException("non-null value required for init parameter " + entry.getKey());
                }
                if (Holder.this.getInitParameter(entry.getKey()) == null) continue;
                if (clash == null) {
                    clash = new HashSet<String>();
                }
                clash.add(entry.getKey());
            }
            if (clash != null) {
                return clash;
            }
            Holder.this.getInitParameters().putAll(initParameters);
            return Collections.emptySet();
        }
    }

    protected class HolderConfig {
        protected HolderConfig() {
        }

        public ServletContext getServletContext() {
            return Holder.this._servletHandler.getServletContext();
        }

        public String getInitParameter(String param) {
            return Holder.this.getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return Holder.this.getInitParameterNames();
        }
    }

    public static enum Source {
        EMBEDDED,
        JAVAX_API,
        DESCRIPTOR,
        ANNOTATION;

    }
}

