/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.TopNHash;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.BytesWritable;

public class PTFTopNHash
extends TopNHash {
    protected float memUsage;
    protected boolean isMapGroupBy;
    private Map<Key, TopNHash> partitionHeaps;
    private TopNHash largestPartition;
    private boolean prevIndexPartIsNull;
    private Set<Integer> indexesWithNullPartKey;

    @Override
    public void initialize(int topN, float memUsage, boolean isMapGroupBy, TopNHash.BinaryCollector collector) {
        super.initialize(topN, memUsage, isMapGroupBy, collector);
        this.isMapGroupBy = isMapGroupBy;
        this.memUsage = memUsage;
        this.partitionHeaps = new HashMap<Key, TopNHash>();
        this.indexesWithNullPartKey = new HashSet<Integer>();
    }

    @Override
    public int tryStoreKey(HiveKey key, boolean partColsIsNull) throws HiveException, IOException {
        this.prevIndexPartIsNull = partColsIsNull;
        return this._tryStoreKey(key, partColsIsNull, -1);
    }

    private void updateLargest(TopNHash p) {
        if (this.largestPartition == null || this.largestPartition.usage < p.usage) {
            this.largestPartition = p;
        }
    }

    private void findLargest() {
        for (TopNHash p : this.partitionHeaps.values()) {
            this.updateLargest(p);
        }
    }

    public int _tryStoreKey(HiveKey key, boolean partColsIsNull, int batchIndex) throws HiveException, IOException {
        if (!this.isEnabled) {
            return -1;
        }
        if (this.topN == 0) {
            return -2;
        }
        Key pk = new Key(partColsIsNull, key.hashCode());
        TopNHash partHeap = this.partitionHeaps.get(pk);
        if (partHeap == null) {
            partHeap = new TopNHash();
            partHeap.initialize(this.topN, this.memUsage, this.isMapGroupBy, this.collector);
            if (batchIndex >= 0) {
                partHeap.startVectorizedBatch(this.batchSize);
            }
            this.partitionHeaps.put(pk, partHeap);
        }
        this.usage -= partHeap.usage;
        int r = 0;
        if (batchIndex >= 0) {
            partHeap.tryStoreVectorizedKey(key, false, batchIndex);
        } else {
            r = partHeap.tryStoreKey(key, false);
        }
        this.usage += partHeap.usage;
        this.updateLargest(partHeap);
        if (this.usage > this.threshold) {
            this.usage -= this.largestPartition.usage;
            this.largestPartition.flush();
            this.usage += this.largestPartition.usage;
            this.largestPartition = null;
            this.findLargest();
        }
        return r;
    }

    @Override
    public void storeValue(int index, int hashCode, BytesWritable value, boolean vectorized) {
        Key pk = new Key(this.prevIndexPartIsNull, hashCode);
        TopNHash partHeap = this.partitionHeaps.get(pk);
        this.usage -= partHeap.usage;
        partHeap.storeValue(index, hashCode, value, vectorized);
        this.usage += partHeap.usage;
        this.updateLargest(partHeap);
    }

    @Override
    public void flush() throws HiveException {
        if (!this.isEnabled || this.topN == 0) {
            return;
        }
        for (TopNHash partHash : this.partitionHeaps.values()) {
            partHash.flush();
        }
    }

    @Override
    public int startVectorizedBatch(int size) throws IOException, HiveException {
        if (!this.isEnabled) {
            return -1;
        }
        if (this.topN == 0) {
            return -2;
        }
        for (TopNHash partHash : this.partitionHeaps.values()) {
            this.usage -= partHash.usage;
            partHash.startVectorizedBatch(size);
            this.usage += partHash.usage;
            this.updateLargest(partHash);
        }
        this.batchSize = size;
        if (this.batchIndexToResult == null || this.batchIndexToResult.length < this.batchSize) {
            this.batchIndexToResult = new int[Math.max(this.batchSize, 1024)];
        }
        this.indexesWithNullPartKey.clear();
        return 0;
    }

    @Override
    public void tryStoreVectorizedKey(HiveKey key, boolean partColsIsNull, int batchIndex) throws HiveException, IOException {
        this._tryStoreKey(key, partColsIsNull, batchIndex);
        if (partColsIsNull) {
            this.indexesWithNullPartKey.add(batchIndex);
        }
        this.batchIndexToResult[batchIndex] = key.hashCode();
    }

    @Override
    public int getVectorizedBatchResult(int batchIndex) {
        this.prevIndexPartIsNull = this.indexesWithNullPartKey.contains(batchIndex);
        Key pk = new Key(this.prevIndexPartIsNull, this.batchIndexToResult[batchIndex]);
        TopNHash partHeap = this.partitionHeaps.get(pk);
        return partHeap.getVectorizedBatchResult(batchIndex);
    }

    @Override
    public HiveKey getVectorizedKeyToForward(int batchIndex) {
        this.prevIndexPartIsNull = this.indexesWithNullPartKey.contains(batchIndex);
        Key pk = new Key(this.prevIndexPartIsNull, this.batchIndexToResult[batchIndex]);
        TopNHash partHeap = this.partitionHeaps.get(pk);
        return partHeap.getVectorizedKeyToForward(batchIndex);
    }

    @Override
    public int getVectorizedKeyDistLength(int batchIndex) {
        this.prevIndexPartIsNull = this.indexesWithNullPartKey.contains(batchIndex);
        Key pk = new Key(this.prevIndexPartIsNull, this.batchIndexToResult[batchIndex]);
        TopNHash partHeap = this.partitionHeaps.get(pk);
        return partHeap.getVectorizedKeyDistLength(batchIndex);
    }

    @Override
    public int getVectorizedKeyHashCode(int batchIndex) {
        this.prevIndexPartIsNull = this.indexesWithNullPartKey.contains(batchIndex);
        Key pk = new Key(this.prevIndexPartIsNull, this.batchIndexToResult[batchIndex]);
        TopNHash partHeap = this.partitionHeaps.get(pk);
        return partHeap.getVectorizedKeyHashCode(batchIndex);
    }

    static class Key {
        boolean isNull;
        int hashCode;

        public Key(boolean isNull, int hashCode) {
            this.isNull = isNull;
            this.hashCode = hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            return this.isNull == other.isNull;
        }

        public String toString() {
            return "" + this.hashCode + "," + this.isNull;
        }
    }
}

