/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormatImpl;
import org.apache.hadoop.hive.ql.io.HivePassThroughOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.io.SequenceFileInputFormatChecker;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Shell;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveFileFormatUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HiveFileFormatUtils.class);
    private static final int S_IFIFO = 4096;

    public static Class<? extends OutputFormat> getOutputFormatSubstitute(Class<?> origin) {
        if (origin == null || HiveOutputFormat.class.isAssignableFrom(origin)) {
            return origin;
        }
        Class<? extends OutputFormat> substitute = FileChecker.getInstance().getOutputFormatSubstiture(origin);
        if (substitute != null) {
            return substitute;
        }
        return origin;
    }

    public static boolean checkInputFormat(FileSystem fs, HiveConf conf, Class<? extends InputFormat> inputFormatCls, List<FileStatus> files) throws HiveException {
        if (files.isEmpty()) {
            return false;
        }
        Class<? extends InputFormatChecker> checkerCls = FileChecker.getInstance().getInputFormatCheckerClass(inputFormatCls);
        if (checkerCls == null && inputFormatCls.isAssignableFrom(TextInputFormat.class)) {
            return HiveFileFormatUtils.checkTextInputFormat(fs, conf, files);
        }
        if (checkerCls != null) {
            InputFormatChecker checkerInstance = FileChecker.getInstance().getInputFormatCheckerInstance(checkerCls);
            try {
                if (checkerInstance == null) {
                    checkerInstance = checkerCls.newInstance();
                    FileChecker.getInstance().putInputFormatCheckerInstance(checkerCls, checkerInstance);
                }
                return checkerInstance.validateInput(fs, conf, files);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        return true;
    }

    private static boolean checkTextInputFormat(FileSystem fs, HiveConf conf, List<FileStatus> files) throws HiveException {
        LinkedList<FileStatus> files2 = new LinkedList<FileStatus>(files);
        Iterator iter = files2.iterator();
        while (iter.hasNext()) {
            FileStatus file = (FileStatus)iter.next();
            if (file == null || !HiveFileFormatUtils.isPipe(fs, file)) continue;
            LOG.info("Skipping format check for " + file.getPath() + " as it is a pipe");
            iter.remove();
        }
        if (files2.isEmpty()) {
            return true;
        }
        Set<Class<? extends InputFormat>> inputFormatter = FileChecker.getInstance().registeredClasses();
        for (Class<? extends InputFormat> reg : inputFormatter) {
            boolean result = HiveFileFormatUtils.checkInputFormat(fs, conf, reg, files2);
            if (!result) continue;
            return false;
        }
        return true;
    }

    private static boolean isPipe(FileSystem fs, FileStatus file) {
        if (fs instanceof DistributedFileSystem) {
            return false;
        }
        int mode = 0;
        Object pathToLog = file.getPath();
        try {
            java.nio.file.Path realPath = Paths.get(file.getPath().toUri());
            pathToLog = realPath;
            mode = (Integer)Files.getAttribute(realPath, "unix:mode", new LinkOption[0]);
        }
        catch (FileSystemNotFoundException t) {
            return false;
        }
        catch (IOException | IllegalArgumentException | SecurityException | UnsupportedOperationException t) {
            LOG.info("Failed to check mode for " + pathToLog + ": " + t.getMessage() + " (" + t.getClass() + ")");
            return false;
        }
        return (mode & 0x1000) != 0;
    }

    public static FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, TableDesc tableInfo, Class<? extends Writable> outputClass, FileSinkDesc conf, Path outPath, Reporter reporter) throws HiveException {
        HiveOutputFormat<?, ?> hiveOutputFormat = HiveFileFormatUtils.getHiveOutputFormat((Configuration)jc, tableInfo);
        try {
            boolean isCompressed = conf.getCompressed();
            JobConf jc_output = jc;
            if (isCompressed) {
                String type;
                jc_output = new JobConf((Configuration)jc);
                String codecStr = conf.getCompressCodec();
                if (codecStr != null && !codecStr.trim().equals("")) {
                    Class codec = JavaUtils.loadClass(codecStr);
                    FileOutputFormat.setOutputCompressorClass((JobConf)jc_output, (Class)codec);
                }
                if ((type = conf.getCompressType()) != null && !type.trim().equals("")) {
                    SequenceFile.CompressionType style = SequenceFile.CompressionType.valueOf((String)type);
                    SequenceFileOutputFormat.setOutputCompressionType((JobConf)jc, (SequenceFile.CompressionType)style);
                }
            }
            return HiveFileFormatUtils.getRecordWriter(jc_output, hiveOutputFormat, outputClass, isCompressed, tableInfo.getProperties(), outPath, reporter);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public static FileSinkOperator.RecordWriter getRecordWriter(JobConf jc, OutputFormat<?, ?> outputFormat, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProp, Path outPath, Reporter reporter) throws IOException, HiveException {
        if (!(outputFormat instanceof HiveOutputFormat)) {
            outputFormat = new HivePassThroughOutputFormat(outputFormat);
        }
        return ((HiveOutputFormat)outputFormat).getHiveRecordWriter(jc, outPath, valueClass, isCompressed, tableProp, (Progressable)reporter);
    }

    public static HiveOutputFormat<?, ?> getHiveOutputFormat(Configuration conf, TableDesc tableDesc) throws HiveException {
        return HiveFileFormatUtils.getHiveOutputFormat(conf, tableDesc.getOutputFileFormatClass(), tableDesc.getProperties());
    }

    public static HiveOutputFormat<?, ?> getHiveOutputFormat(Configuration conf, PartitionDesc partDesc) throws HiveException {
        return HiveFileFormatUtils.getHiveOutputFormat(conf, partDesc.getOutputFileFormatClass(), partDesc.getProperties());
    }

    private static HiveOutputFormat<?, ?> getHiveOutputFormat(Configuration conf, Class<? extends OutputFormat> outputClass, Properties properties) throws HiveException {
        try {
            if (outputClass == HivePassThroughOutputFormat.class) {
                outputClass = properties != null && properties.getProperty("storage_handler", "").equals("org.apache.hadoop.hive.hbase.HBaseStorageHandler") ? Class.forName("org.apache.hadoop.hive.hbase.HiveHBaseTableOutputFormat") : HiveOutputFormatImpl.class;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        HivePassThroughOutputFormat outputFormat = ReflectionUtil.newInstance(outputClass, conf);
        if (!(outputFormat instanceof HiveOutputFormat)) {
            outputFormat = new HivePassThroughOutputFormat(outputFormat);
        }
        return outputFormat;
    }

    public static RecordUpdater getAcidRecordUpdater(JobConf jc, TableDesc tableInfo, int bucket, FileSinkDesc conf, Path outPath, ObjectInspector inspector, Reporter reporter, int rowIdColNum) throws HiveException, IOException {
        HiveOutputFormat<?, ?> hiveOutputFormat = HiveFileFormatUtils.getHiveOutputFormat((Configuration)jc, tableInfo);
        AcidOutputFormat acidOutputFormat = null;
        if (!(hiveOutputFormat instanceof AcidOutputFormat)) {
            throw new HiveException("Unable to create RecordUpdater for HiveOutputFormat that does not implement AcidOutputFormat");
        }
        acidOutputFormat = (AcidOutputFormat)hiveOutputFormat;
        return HiveFileFormatUtils.getRecordUpdater(jc, acidOutputFormat, bucket, inspector, tableInfo.getProperties(), outPath, reporter, rowIdColNum, conf);
    }

    private static RecordUpdater getRecordUpdater(JobConf jc, AcidOutputFormat<?, ?> acidOutputFormat, int bucket, ObjectInspector inspector, Properties tableProp, Path outPath, Reporter reporter, int rowIdColNum, FileSinkDesc conf) throws IOException {
        return acidOutputFormat.getRecordUpdater(outPath, new AcidOutputFormat.Options((Configuration)jc).isCompressed(conf.getCompressed()).tableProperties(tableProp).reporter(reporter).writingBase(false).minimumTransactionId(conf.getTransactionId()).maximumTransactionId(conf.getTransactionId()).bucket(bucket).inspector(inspector).recordIdColumn(rowIdColNum).statementId(conf.getStatementId()).finalDestination(conf.getDestPath()));
    }

    public static PartitionDesc getPartitionDescFromPathRecursively(Map<String, PartitionDesc> pathToPartitionInfo, Path dir, Map<Map<String, PartitionDesc>, Map<String, PartitionDesc>> cacheMap) throws IOException {
        return HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, dir, cacheMap, false);
    }

    public static PartitionDesc getPartitionDescFromPathRecursively(Map<String, PartitionDesc> pathToPartitionInfo, Path dir, Map<Map<String, PartitionDesc>, Map<String, PartitionDesc>> cacheMap, boolean ignoreSchema) throws IOException {
        PartitionDesc part = HiveFileFormatUtils.doGetPartitionDescFromPath(pathToPartitionInfo, dir);
        if (part == null && (ignoreSchema || dir.toUri().getScheme() == null || dir.toUri().getScheme().trim().equals("") || HiveFileFormatUtils.pathsContainNoScheme(pathToPartitionInfo))) {
            Map<String, PartitionDesc> newPathToPartitionInfo = null;
            if (cacheMap != null) {
                newPathToPartitionInfo = cacheMap.get(pathToPartitionInfo);
            }
            if (newPathToPartitionInfo == null) {
                newPathToPartitionInfo = new HashMap<String, PartitionDesc>();
                HiveFileFormatUtils.populateNewPartitionDesc(pathToPartitionInfo, newPathToPartitionInfo);
                if (cacheMap != null) {
                    cacheMap.put(pathToPartitionInfo, newPathToPartitionInfo);
                }
            }
            part = HiveFileFormatUtils.doGetPartitionDescFromPath(newPathToPartitionInfo, dir);
        }
        if (part != null) {
            return part;
        }
        throw new IOException("cannot find dir = " + dir.toString() + " in pathToPartitionInfo: " + pathToPartitionInfo.keySet());
    }

    private static boolean pathsContainNoScheme(Map<String, PartitionDesc> pathToPartitionInfo) {
        for (Map.Entry<String, PartitionDesc> pe : pathToPartitionInfo.entrySet()) {
            if (new Path(pe.getKey()).toUri().getScheme() == null) continue;
            return false;
        }
        return true;
    }

    private static void populateNewPartitionDesc(Map<String, PartitionDesc> pathToPartitionInfo, Map<String, PartitionDesc> newPathToPartitionInfo) {
        for (Map.Entry<String, PartitionDesc> entry : pathToPartitionInfo.entrySet()) {
            String entryKey = entry.getKey();
            PartitionDesc partDesc = entry.getValue();
            Path newP = new Path(entryKey);
            String pathOnly = newP.toUri().getPath();
            newPathToPartitionInfo.put(pathOnly, partDesc);
        }
    }

    private static PartitionDesc doGetPartitionDescFromPath(Map<String, PartitionDesc> pathToPartitionInfo, Path dir) {
        URI uri = dir.toUri();
        try {
            URI normURI = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
            dir = new Path(normURI);
        }
        catch (URISyntaxException normURI) {
            // empty catch block
        }
        String dirPath = dir.toUri().getPath();
        PartitionDesc part = pathToPartitionInfo.get(dir.toString());
        if (part == null) {
            part = pathToPartitionInfo.get(dirPath);
        }
        if (part == null) {
            Path curPath = new Path(dir.toUri().getPath()).getParent();
            dir = dir.getParent();
            while (dir != null) {
                part = pathToPartitionInfo.get(dir.toString());
                if (part == null) {
                    part = pathToPartitionInfo.get(curPath.toString());
                }
                if (part != null) break;
                dir = dir.getParent();
                curPath = curPath.getParent();
            }
        }
        return part;
    }

    private static boolean foundAlias(Map<String, ArrayList<String>> pathToAliases, String path) {
        List aliases = pathToAliases.get(path);
        return aliases != null && !aliases.isEmpty();
    }

    private static String getMatchingPath(Map<String, ArrayList<String>> pathToAliases, Path dir) {
        URI uri = dir.toUri();
        try {
            URI normURI = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
            dir = new Path(normURI);
        }
        catch (URISyntaxException normURI) {
            // empty catch block
        }
        String path = dir.toString();
        if (HiveFileFormatUtils.foundAlias(pathToAliases, path)) {
            return path;
        }
        String dirPath = dir.toUri().getPath();
        if (Shell.WINDOWS) {
            dirPath = new Path(dirPath).toString();
        }
        if (HiveFileFormatUtils.foundAlias(pathToAliases, dirPath)) {
            return dirPath;
        }
        path = dirPath;
        String dirStr = dir.toString();
        int dirPathIndex = dirPath.lastIndexOf("/");
        int dirStrIndex = dirStr.lastIndexOf("/");
        while (dirPathIndex >= 0 && dirStrIndex >= 0) {
            dirStr = dirStr.substring(0, dirStrIndex);
            dirPath = dirPath.substring(0, dirPathIndex);
            if (HiveFileFormatUtils.foundAlias(pathToAliases, dirStr)) {
                return dirStr;
            }
            if (HiveFileFormatUtils.foundAlias(pathToAliases, dirPath)) {
                return dirPath;
            }
            dirPathIndex = dirPath.lastIndexOf("/");
            dirStrIndex = dirStr.lastIndexOf("/");
        }
        return null;
    }

    public static List<Operator<? extends OperatorDesc>> doGetWorksFromPath(Map<String, ArrayList<String>> pathToAliases, Map<String, Operator<? extends OperatorDesc>> aliasToWork, Path dir) {
        ArrayList<Operator<? extends OperatorDesc>> opList = new ArrayList<Operator<? extends OperatorDesc>>();
        List<String> aliases = HiveFileFormatUtils.doGetAliasesFromPath(pathToAliases, dir);
        for (String alias : aliases) {
            opList.add(aliasToWork.get(alias));
        }
        return opList;
    }

    public static List<String> doGetAliasesFromPath(Map<String, ArrayList<String>> pathToAliases, Path dir) {
        if (pathToAliases == null) {
            return new ArrayList<String>();
        }
        String path = HiveFileFormatUtils.getMatchingPath(pathToAliases, dir);
        return pathToAliases.get(path);
    }

    private HiveFileFormatUtils() {
    }

    public static void prepareJobOutput(JobConf conf) {
        conf.setOutputCommitter(NullOutputCommitter.class);
        conf.setBoolean("mapreduce.job.committer.setup.cleanup.needed", false);
        conf.setBoolean("mapreduce.job.committer.task.cleanup.needed", false);
    }

    public static class NullOutputCommitter
    extends OutputCommitter {
        public void setupJob(JobContext jobContext) {
        }

        public void cleanupJob(JobContext jobContext) {
        }

        public void setupTask(TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) {
            return false;
        }

        public void commitTask(TaskAttemptContext taskContext) {
        }

        public void abortTask(TaskAttemptContext taskContext) {
        }
    }

    public static class FileChecker {
        private static int MAX_CACHE_SIZE = 16;
        Map<Class<? extends InputFormat>, Class<? extends InputFormatChecker>> inputFormatCheckerMap = ImmutableMap.builder().put(SequenceFileInputFormat.class, SequenceFileInputFormatChecker.class).put(RCFileInputFormat.class, RCFileInputFormat.class).put(OrcInputFormat.class, OrcInputFormat.class).build();
        Map<Class<?>, Class<? extends OutputFormat>> outputFormatSubstituteMap = ImmutableMap.builder().put(IgnoreKeyTextOutputFormat.class, HiveIgnoreKeyTextOutputFormat.class).put(SequenceFileOutputFormat.class, HiveSequenceFileOutputFormat.class).build();
        Cache<Class<? extends InputFormatChecker>, InputFormatChecker> inputFormatCheckerInstanceCache = CacheBuilder.newBuilder().maximumSize(MAX_CACHE_SIZE).build();

        public static FileChecker getInstance() {
            return Factory.INSTANCE;
        }

        private FileChecker() {
        }

        public Set<Class<? extends InputFormat>> registeredClasses() {
            return this.inputFormatCheckerMap.keySet();
        }

        public Class<? extends OutputFormat> getOutputFormatSubstiture(Class<?> origin) {
            return this.outputFormatSubstituteMap.get(origin);
        }

        public Class<? extends InputFormatChecker> getInputFormatCheckerClass(Class<?> inputFormat) {
            return this.inputFormatCheckerMap.get(inputFormat);
        }

        public void putInputFormatCheckerInstance(Class<? extends InputFormatChecker> checkerCls, InputFormatChecker instanceCls) {
            this.inputFormatCheckerInstanceCache.put(checkerCls, instanceCls);
        }

        public InputFormatChecker getInputFormatCheckerInstance(Class<? extends InputFormatChecker> checkerCls) {
            return this.inputFormatCheckerInstanceCache.getIfPresent(checkerCls);
        }

        private static class Factory {
            static final FileChecker INSTANCE = new FileChecker();

            private Factory() {
            }
        }
    }
}

