/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.cda;

import java.util.LinkedHashMap;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.CdaQueryBackend;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.CdaQueryEntry;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.HttpQueryBackend;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class CdaDataFactory
extends AbstractDataFactory {
    private LinkedHashMap<String, CdaQueryEntry> queries = new LinkedHashMap();
    private String baseUrl;
    private String baseUrlField;
    private boolean useLocalCall = true;
    private String username;
    private String password;
    private String solution;
    private String path;
    private String file;
    private boolean sugarMode;
    private CdaQueryBackend backend;
    private transient CdaQueryBackend effectiveBackend;

    public boolean isUseLocalCall() {
        return this.useLocalCall;
    }

    public void setUseLocalCall(boolean useLocalCall) {
        this.useLocalCall = useLocalCall;
    }

    public void cancelRunningQuery() {
        if (this.effectiveBackend != null) {
            this.effectiveBackend.cancelRunningQuery();
        }
    }

    public void close() {
    }

    public String[] getQueryNames() {
        return this.queries.keySet().toArray(new String[this.queries.size()]);
    }

    public void initialize(DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        super.initialize(dataFactoryContext);
        if (this.backend != null) {
            this.effectiveBackend = this.backend;
        } else {
            if (this.useLocalCall) {
                String className = this.getConfiguration().getConfigProperty(CdaQueryBackend.class.getName());
                this.effectiveBackend = (CdaQueryBackend)ObjectUtilities.loadAndInstantiate((String)className, CdaQueryBackend.class, CdaQueryBackend.class);
            }
            if (this.effectiveBackend == null) {
                this.effectiveBackend = new HttpQueryBackend();
            }
        }
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.queries.containsKey(query);
    }

    public void setQueryEntry(String name, CdaQueryEntry cdaqueryentry) {
        if (cdaqueryentry == null) {
            this.queries.remove(name);
        } else {
            this.queries.put(name, cdaqueryentry);
        }
    }

    public CdaQueryEntry getQueryEntry(String name) {
        return this.queries.get(name);
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        CdaQueryEntry realQuery = this.getQueryEntry(query);
        this.effectiveBackend.setFile(this.getFile());
        this.effectiveBackend.setSolution(this.getSolution());
        this.effectiveBackend.setPath(this.getPath());
        this.effectiveBackend.setUsername(this.getUsername());
        this.effectiveBackend.setPassword(this.getPassword());
        this.effectiveBackend.setBaseUrl(this.computeBaseUrl(parameters));
        this.effectiveBackend.initialize(this.getDataFactoryContext());
        this.effectiveBackend.setSugarMode(this.isSugarMode());
        return this.effectiveBackend.queryData(realQuery, parameters);
    }

    private String computeBaseUrl(DataRow dataRow) {
        Object baseUrlRaw;
        if (this.baseUrlField != null && (baseUrlRaw = dataRow.get(this.baseUrlField)) != null) {
            return String.valueOf(baseUrlRaw);
        }
        return this.baseUrl;
    }

    public CdaDataFactory clone() {
        CdaDataFactory dataFactory = (CdaDataFactory)super.clone();
        dataFactory.queries = (LinkedHashMap)this.queries.clone();
        if (this.backend != null) {
            dataFactory.backend = (CdaQueryBackend)this.backend.clone();
        }
        return dataFactory;
    }

    public void setBackend(CdaQueryBackend backend) {
        if (backend == null) {
            throw new NullPointerException();
        }
        this.backend = backend;
    }

    public CdaQueryBackend getBackend() {
        return this.backend;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrlField() {
        return this.baseUrlField;
    }

    public void setBaseUrlField(String baseUrlField) {
        this.baseUrlField = baseUrlField;
    }

    public boolean isSugarMode() {
        return this.sugarMode;
    }

    public void setSugarMode(boolean sugarMode) {
        this.sugarMode = sugarMode;
    }
}

