/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.cda.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.parser.VariableReadHandler;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class QueryReadHandler
extends PropertyReadHandler {
    private String queryName;
    private String queryId;
    private ArrayList<VariableReadHandler> variables = new ArrayList();
    private ParameterMapping[] queryParameters;
    private boolean legacyParsing;

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.queryId = this.queryName = attrs.getValue(this.getUri(), "name");
        if (this.queryName == null) {
            throw new ParseException("Required attribute 'name' is not defined");
        }
        this.queryId = attrs.getValue(this.getUri(), "query");
        if (StringUtils.isEmpty((String)this.queryId)) {
            this.legacyParsing = true;
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("variable".equals(tagName)) {
            VariableReadHandler readHandler = new VariableReadHandler();
            this.variables.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        if (this.legacyParsing) {
            this.queryId = super.getResult();
        }
        this.queryParameters = new ParameterMapping[this.variables.size()];
        for (int i = 0; i < this.variables.size(); ++i) {
            ParameterMapping queryParameter;
            VariableReadHandler handler = this.variables.get(i);
            this.queryParameters[i] = queryParameter = new ParameterMapping(handler.getDataRowName(), handler.getVariableName());
        }
    }

    public Object getObject() {
        return new ParameterMapping(this.queryName, this.queryId);
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public ParameterMapping[] getParameters() {
        return (ParameterMapping[])this.queryParameters.clone();
    }
}

