/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.util.KMSUtil;

public class KeyProviderCache {
    public static final Log LOG = LogFactory.getLog(KeyProviderCache.class);
    private final Cache<URI, KeyProvider> cache;

    public KeyProviderCache(long expiryMs) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(expiryMs, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<URI, KeyProvider>(){

            public void onRemoval(RemovalNotification<URI, KeyProvider> notification) {
                try {
                    ((KeyProvider)notification.getValue()).close();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error closing KeyProvider with uri [" + notification.getKey() + "]"), e);
                }
            }
        }).build();
    }

    public KeyProvider get(final Configuration conf, final URI serverProviderUri) {
        if (serverProviderUri == null) {
            return null;
        }
        try {
            return (KeyProvider)this.cache.get((Object)serverProviderUri, (Callable)new Callable<KeyProvider>(){

                @Override
                public KeyProvider call() throws Exception {
                    return KMSUtil.createKeyProviderFromUri((Configuration)conf, (URI)serverProviderUri);
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Could not create KeyProvider for DFSClient !!", (Throwable)e);
            return null;
        }
    }

    private URI createKeyProviderURI(Configuration conf) {
        URI providerUri;
        String providerUriStr = conf.getTrimmed("dfs.encryption.key.provider.uri");
        if (providerUriStr == null || providerUriStr.isEmpty()) {
            LOG.error((Object)"Could not find uri with key [dfs.encryption.key.provider.uri] to create a keyProvider !!");
            return null;
        }
        try {
            providerUri = new URI(providerUriStr);
        }
        catch (URISyntaxException e) {
            LOG.error((Object)("KeyProvider URI string is invalid [" + providerUriStr + "]!!"), e.getCause());
            return null;
        }
        return providerUri;
    }

    @VisibleForTesting
    public void setKeyProvider(Configuration conf, KeyProvider keyProvider) throws IOException {
        URI uri = this.createKeyProviderURI(conf);
        this.cache.put((Object)uri, (Object)keyProvider);
    }
}

