define(["../_base/array","../hash","../router/RouterBase","doh"],function(n,f,m,g){function h(a){n.forEach(a,function(b){b.remove()})}var e=0,c=new m,d;g.register("tests.router",[{name:"Router API",setUp:function(a){f("",!0)},runTest:function(a){a.t(c.register,"Router has a register");a.t(c.go,"Router has a go");a.t(c.startup,"Router has a startup");a.t(c.destroy,"Router has a destroy")}},{name:"Registering a route by string",runTest:function(a){d=c.register("/foo",function(){e++;console.log("/foo fired! New count:",
e)});a.t(d.remove,"Handle has a remove");a.t(d.register,"Handle has a register")}},{name:"Ensuring routes don't fire before startup",setUp:function(){e=0},runTest:function(a){f("/foo");a.t(0===e,"Count should have been 0, was "+e)}},{name:"Ensuring routes do fire after startup",runTest:function(a){c.startup();a.t(1===e,"Count should have been 1, was "+e)}},{name:"Ensuring that hash changes fire routes",runTest:function(a){var b=new g.Deferred;f("");setTimeout(function(){f("/foo");console.log("Setting hash");
setTimeout(b.getTestCallback(function(){console.log("Checking count, current hash:",f());a.t(2===e,"Count should have been 2, was "+e)}),50)},0);return b}},{name:"Ensuring that router.go fires changes",runTest:function(a){new g.Deferred;c.go("");c.go("/foo");a.t(3===e,"Count should have been 3, was "+e)}},{name:"Ensuring route doesn't fire after removal",runTest:function(a){d.remove();c.go("");c.go("/foo");a.t(3===e,"Count should have been 3, was "+e)}},{name:"Registering a route by regexp",runTest:function(a){d=
c.register(/^\/bar$/,function(){e++});c.go("/bar");a.t(4===e,"Count should have been 4, was "+e)},tearDown:function(){d.remove()}},{name:"Checking event object",runTest:function(a){var b,k,e,f,l;c.go("");d=c.register("/checkEventObject/:foo",function(a){b=a.oldPath;k=a.newPath;e=a.params;f=typeof a.stopImmediatePropagation;l=typeof a.preventDefault});c.go("/checkEventObject/bar");a.t(""===b,"oldPath should be empty string, was "+b);a.t("/checkEventObject/bar"===k,"newPath should be '/checkEventObject/bar', was "+
k);a.t(e,"params should be a truthy value, was "+e);a.t(e.hasOwnProperty("foo"),"params should have a .foo property");a.t("bar"===e.foo,"params.foo should be bar, was "+e.foo);a.t("function"===f,"stopImmediatePropagation should be a function, was "+f);a.t("function"===l,"preventDefault should be a function, was "+l)},tearDown:function(){d.remove()}},{name:"Checking extra arguments - string route",runTest:function(a){var b,e;d=c.register("/stringtest/:applied/:arg",function(a,c,d){b=c;e=d});c.go("/stringtest/extra/args");
a.t("extra"===b,"a should have been 'extra', was "+b);a.t("args"===e,"b should have been 'args', was "+e)},tearDown:function(){d.remove()}},{name:"Checking extra arguments - regex route",runTest:function(a){var b,e;d=c.register(/\/regextest\/(\w+)\/(\w+)/,function(a,c,d){b=c;e=d});c.go("/regextest/extra/args");a.t("extra"===b,"a should have been 'extra', was "+b);a.t("args"===e,"b should have been 'args', was "+e)},tearDown:function(){d.remove()}},{name:"Registering long routes with placeholders",
runTest:function(a){var b;d=c.register("/path/:to/:some/:long/*thing",function(a){b=a.params});c.go("/path/to/some/long/thing/this/is/in/splat");a.t(b instanceof Object,"testObject should have been an object, but wasn't");a.t("to"===b.to,"testObject.to should have been 'to', was "+b.to);a.t("some"===b.some,"testObject.some should have been 'some', was "+b.some);a.t("long"===b["long"],"testObject.long should have been 'long', was "+b["long"]);a.t("thing/this/is/in/splat"===b.thing,"testObject.thing should have been 'thing/this/is/in/splat', was "+
b.thing);b=null;c.go("/path/1/2/3/4/5/6");a.t(b instanceof Object,"testObject should have been an object, but wasn't");a.t("1"===b.to,"testObject.to should have been '1', was "+b.to);a.t("2"===b.some,"testObject.some should have been '2', was "+b.some);a.t("3"===b["long"],"testObject.long should have been '3', was "+b["long"]);a.t("4/5/6"===b.thing,"testObject.thing should have been '4/5/6', was "+b.thing)},tearDown:function(){d.remove()}},{name:"Using capture groups in a regex route",runTest:function(a){var b;
d=c.register(/^\/path\/(\w+)\/(\d+)$/,function(a){b=a.params});c.go("/path/abcdef/1234");a.t(b instanceof Array,"testObject should have been an array, but wasn't");a.t("abcdef"===b[0],"testObject[0] should have been 'abcdef', was "+b[0]);a.t("1234"===b[1],"testObject[1] should have been '1234', was "+b[1]);b=null;c.go("/path/abc/def");a.t(null===b,"testObject should have been null, but wasn't");c.go("/path/abc123/456def");a.t(null===b,"testObject should have been null, but wasn't");c.go("/path/abc123/456");
a.t(b instanceof Array,"testObject should have been an array, but wasn't");a.t("abc123"===b[0],"testObject[0] should have been 'abc123', was "+b[0]);a.t("456"===b[1],"testObject[1] should have been '456', was "+b[1])},tearDown:function(){d.remove()}},{name:"Testing registerBefore",runTest:function(a){var b="";d=[];d.push(c.register("/isBefore",function(){b+="1"}));d.push(c.registerBefore("/isBefore",function(){b+="2"}));d.push(c.register("/isBefore",function(){b+="3"}));d.push(c.registerBefore("/isBefore",
function(){b+="4"}));d.push(c.register("/isBefore",function(){b+="5"}));c.go("/isBefore");a.t("42135"===b,"test should have been '42135', was "+b)},tearDown:function(){h(d)}},{name:"Stopping propagation",runTest:function(a){var b="";d=[];d.push(c.register("/stopImmediatePropagation",function(){b+="A"}));d.push(c.register("/stopImmediatePropagation",function(){b+="B"}));d.push(c.register("/stopImmediatePropagation",function(a){a.stopImmediatePropagation();b+="C"}));d.push(c.register("/stopImmediatePropagation",
function(){b+="D"}));d.push(c.register("/stopImmediatePropagation",function(){b+="E"}));c.go("/stopImmediatePropagation");a.t("ABC"===b,"test should have been 'ABC', was "+b)},tearDown:function(){h(d)}},{name:"Preventing default (change)",runTest:function(a){var b;f("");a.t(""===f(),"hash should be empty");d.push(c.register("/preventDefault",function(a){a.preventDefault()}));b=c.go("/preventDefault");a.t(""===f(),"hash should still be empty");a.t(!1===b,"goResult should be false");b=c.go("/someOtherPath");
a.t("/someOtherPath"===f(),"hash should be '/someOtherPath'");a.t(!0===b,"goResult should be true");d.push(c.register("/allowDefault",function(a){console.log("Doing something here without explicitly stopping")}))},tearDown:function(){h(d)}},{name:"Default router path",setUp:function(){c.destroy();c=new m;f("")},runTest:function(a){var b=!1;d=c.register("/default",function(a){b=!0});c.startup("/default");a.t(b,"Our route was not hit, but should have been")},tearDown:function(){d.remove()}}])});
//# sourceMappingURL=router.js.map