/*
 * Copyright 2006 Pentaho Corporation.  All rights reserved. 
 * This software was developed by Pentaho Corporation and is provided under the terms 
 * of the Mozilla Public License, Version 1.1, or any later version. You may not use 
 * this file except in compliance with the license. If you need a copy of the license, 
 * please go to http://www.mozilla.org/MPL/MPL-1.1.txt. The Original Code is the Pentaho 
 * BI Platform.  The Initial Developer is Pentaho Corporation.
 *
 * Software distributed under the Mozilla Public License is distributed on an "AS IS" 
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or  implied. Please refer to 
 * the license for the specific language governing your rights and limitations.
*/
package org.pentaho.pms.cwm.pentaho.meta.expressions;

/**
 * ConstantNode object instance interface.
 * Instances of the ConstantNode class are ExpressionNodes that represent 
 * constant values within expressions. Appropriate uses of the ConstantNode 
 * class place the values of constants in the value attribute, rather than 
 * in the expression::body attribute inherited from ExpressionNode. The latter 
 * attribute is intended for a different purpose; see the description of the 
 * ExpressionNode class for details.
 *  
 * <p><em><strong>Note:</strong> This type should not be subclassed or implemented 
 * by clients. It is generated from a MOF metamodel and automatically implemented 
 * by MDR (see <a href="http://mdr.netbeans.org/">mdr.netbeans.org</a>).</em></p>
 */
public interface CwmConstantNode extends org.pentaho.pms.cwm.pentaho.meta.expressions.CwmExpressionNode {
    /**
     * Returns the value of attribute value.
     * The value of a constant in an expression tree.
     * @return Value of attribute value.
     */
    public java.lang.String getValue();
    /**
     * Sets the value of value attribute. See {@link #getValue} for description 
     * on the attribute.
     * @param newValue New value to be set.
     */
    public void setValue(java.lang.String newValue);
}
