/*
 * Decompiled with CFR 0.152.
 */
package principal.cli;

import controlador.Diagrama;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import principal.cli.CliDiagramaProcessador;
import util.DesenhadorDeTexto;

public class MasterCli
extends JPanel
implements KeyListener {
    private char key = (char)46;
    private String prompt = "# ";
    private final int espaco = 5;
    private int posCursor = 0;
    private StringBuilder strs = new StringBuilder();
    private Rectangle cliRect = this.getBounds();
    private String palavra = this.prompt;
    private final DesenhadorDeTexto dzExecutado = new DesenhadorDeTexto();
    private final DesenhadorDeTexto dzCli = new DesenhadorDeTexto();
    private int alturaTexto = 0;
    private ArrayList<String> historico = new ArrayList();
    private boolean shiftDown = false;
    private boolean altDown = false;
    private boolean controlDown = false;
    private CliDiagramaProcessador processador = new CliDiagramaProcessador(this);
    private JDialog janela = null;
    private int posHist = -1;

    public MasterCli() {
        this.setBackground(Color.white);
        this.setFocusTraversalKeysEnabled(false);
        this.setDoubleBuffered(true);
        this.setFocusable(true);
        this.addKeyListener(this);
        KeyStroke key_crtl = KeyStroke.getKeyStroke(17, 128);
        KeyStroke key_crtl_up = KeyStroke.getKeyStroke(17, 0, true);
        KeyStroke key_shift = KeyStroke.getKeyStroke(16, 64);
        KeyStroke key_shift_up = KeyStroke.getKeyStroke(16, 0, true);
        KeyStroke key_alt = KeyStroke.getKeyStroke(18, 512);
        KeyStroke key_alt_up = KeyStroke.getKeyStroke(18, 0, true);
        KeyStroke key_tab = KeyStroke.getKeyStroke(9, 0, true);
        String ac_crtl = "AC_CRTL";
        String ac_crtl_up = "AC_CRTL_UP";
        String ac_shift = "AC_SHIFT";
        String ac_shift_up = "AC_SHIFT_UP";
        String ac_alt = "AC_ALT";
        String ac_alt_up = "AC_ALT_UP";
        String ac_tab = "TAB";
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(key_crtl, "AC_CRTL");
        inputMap.put(key_crtl_up, "AC_CRTL_UP");
        inputMap.put(key_shift, "AC_SHIFT");
        inputMap.put(key_shift_up, "AC_SHIFT_UP");
        inputMap.put(key_alt, "AC_ALT");
        inputMap.put(key_alt_up, "AC_ALT_UP");
        inputMap.put(key_tab, "TAB");
        AbstractAction al_crtl = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MasterCli.this.controlDown = true;
            }
        };
        AbstractAction al_crtl_up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MasterCli.this.controlDown = false;
            }
        };
        AbstractAction al_shift = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MasterCli.this.shiftDown = true;
            }
        };
        AbstractAction al_shift_up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MasterCli.this.shiftDown = false;
            }
        };
        AbstractAction al_alt = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MasterCli.this.altDown = true;
            }
        };
        AbstractAction al_alt_up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MasterCli.this.altDown) {
                    MasterCli.this.controlDown = false;
                }
                MasterCli.this.altDown = false;
            }
        };
        AbstractAction al_tab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MasterCli.this.AutoComplete();
            }
        };
        ActionMap actionMap = this.getActionMap();
        actionMap.put("AC_CRTL", al_crtl);
        actionMap.put("AC_CRTL_UP", al_crtl_up);
        actionMap.put("AC_SHIFT", al_shift);
        actionMap.put("AC_SHIFT_UP", al_shift_up);
        actionMap.put("AC_ALT", al_alt);
        actionMap.put("AC_ALT_UP", al_alt_up);
        actionMap.put("TAB", al_tab);
        this.setActionMap(actionMap);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.key = e.getKeyChar();
        if (this.key == '\u007f' || this.key == '\b' || this.key == '\n') {
            e.consume();
            return;
        }
        if (e.getModifiers() == 2) {
            return;
        }
        this.palavra = this.insertChar(this.palavra, this.key);
        ++this.posCursor;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.isControlDown()) {
            if (this.processeAtalhos(e.getKeyCode())) {
                e.consume();
            }
        } else {
            switch (e.getKeyCode()) {
                case 10: {
                    this.doEnter(this.palavra);
                    e.consume();
                    break;
                }
                case 38: {
                    this.posicioneHistorico(1);
                    e.consume();
                    break;
                }
                case 40: {
                    this.posicioneHistorico(-1);
                    e.consume();
                    break;
                }
                case 37: {
                    this.movimenteCursor(-1);
                    e.consume();
                    break;
                }
                case 39: {
                    this.movimenteCursor(1);
                    e.consume();
                    break;
                }
                case 127: {
                    this.apagarLetra(this.posCursor);
                    e.consume();
                    break;
                }
                case 8: {
                    this.apagarLetra(this.posCursor - 1);
                    e.consume();
                }
            }
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public ArrayList<String> getHistorico() {
        return this.historico;
    }

    public void setHistorico(ArrayList<String> historico) {
        this.historico = historico;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public boolean isShiftDown() {
        return this.shiftDown;
    }

    public void setShiftDown(boolean shiftDown) {
        this.shiftDown = shiftDown;
    }

    public boolean isAltDown() {
        return this.altDown;
    }

    public boolean isControlDown() {
        return this.controlDown;
    }

    public void setControlDown(boolean controlDown) {
        this.controlDown = controlDown;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.addRenderingHints(renderHints);
        g2d.setPaint(Color.BLACK);
        BasicStroke stroke = new BasicStroke(2.0f, 2, 0);
        g2d.setStroke(stroke);
        this.PintarTextos(g2d);
    }

    public void Clear() {
        this.strs = new StringBuilder();
        this.strs.append(this.prompt);
        this.repaint();
    }

    private void PintarTextos(Graphics2D g) {
        int pos;
        if (this.strs.length() > 0) {
            this.dzExecutado.PinteTexto(g, Color.BLUE, new Rectangle(5, 5, this.getWidth() - 10, this.getHeight() - 5), this.strs.toString());
        }
        int alturaOld = this.dzExecutado.getMaxHeigth() + 10;
        String txt = this.insertChar(this.palavra, '|');
        this.cliRect = new Rectangle(5, alturaOld, this.getWidth() - 10, this.getHeight());
        this.dzCli.PinteTexto(g, Color.yellow, this.cliRect, txt);
        int recuo = g.getFontMetrics().getDescent();
        int alturaCli = this.dzCli.getMaxHeigth() + 2 * recuo + 5;
        this.cliRect = new Rectangle(5, alturaOld, this.getWidth() - 10, alturaCli);
        g.fillRect(this.cliRect.x, this.cliRect.y, this.cliRect.width, this.cliRect.height);
        this.alturaTexto = pos = alturaCli + alturaOld;
        this.dzCli.PinteTexto(g, Color.black, new Rectangle(this.cliRect.x, this.cliRect.y + recuo, this.cliRect.width, this.cliRect.height - 2 * recuo), txt);
        this.AtualizaTamanho();
    }

    private String insertChar(String apalavra, char c) {
        int tmpTxtPos = this.posCursor + this.getPrompt().length();
        apalavra = apalavra.substring(0, tmpTxtPos) + c + (apalavra.length() > tmpTxtPos ? apalavra.substring(tmpTxtPos, apalavra.length()) : "");
        return apalavra;
    }

    private String insertTexto(String texto, String ainserir) {
        int tmpTxtPos = this.posCursor + this.getPrompt().length();
        texto = texto.substring(0, tmpTxtPos) + ainserir + (texto.length() > tmpTxtPos ? texto.substring(tmpTxtPos, texto.length()) : "");
        return texto;
    }

    public void AtualizaTamanho() {
        int pos = this.alturaTexto;
        if (pos > this.getHeight()) {
            JViewport jvp = (JViewport)this.getParent();
            this.setSize(jvp.getExtentSize().width, pos + 2);
            this.setPreferredSize(this.getSize());
            if (this.alturaTexto > jvp.getHeight()) {
                jvp.setViewPosition(new Point(5, this.getHeight()));
            }
            this.repaint();
        }
    }

    public boolean doEnter(String apalavra) {
        this.appendHistorico(apalavra);
        this.strs.append(apalavra).append("\n");
        String ret = this.getProcessador().processeComando(apalavra.substring(this.getPrompt().length()));
        if (!ret.isEmpty() && !ret.equals(this.getProcessador().msgNOTHING)) {
            this.strs.append(ret).append("\n");
        }
        if (this.getProcessador().isJustNewLine()) {
            this.palavra = this.getPrompt();
            this.posCursor = 0;
            this.cliRect = this.getBounds();
        }
        this.repaint();
        return this.getProcessador().isLastCmdErro();
    }

    public CliDiagramaProcessador getProcessador() {
        return this.processador;
    }

    public void setProcessador(CliDiagramaProcessador processador) {
        this.processador = processador;
    }

    public void doPaste() {
        String txt = Diagrama.getClipboardContents();
        if (txt.isEmpty()) {
            return;
        }
        this.donePaste(txt);
        this.AtualizaTamanho();
    }

    private void donePaste(String txt) {
        String[] comms;
        String tmp = this.palavra.substring(this.prompt.length());
        if (!tmp.isEmpty()) {
            txt = this.insertTexto(this.palavra, txt).substring(this.prompt.length());
        }
        for (String str : comms = txt.replaceAll("\r\n", "\n").split("\n")) {
            this.posCursor = (this.prompt + str).length();
            if (this.doEnter(this.prompt + str)) continue;
            this.doShowMsg(this.getProcessador().getErroMsg());
        }
    }

    public void doPaste(String txt) {
        if (txt.isEmpty()) {
            return;
        }
        this.donePaste(txt);
        this.AtualizaTamanho();
    }

    public void doShowMsg(String msg) {
        this.strs.append(msg).append("\n");
        this.palavra = this.getPrompt();
        this.posCursor = 0;
        this.cliRect = this.getBounds();
        this.repaint(this.cliRect);
    }

    public void Cancelar() {
        this.doShowMsg(this.getProcessador().doCancel());
    }

    public boolean processeAtalhos(int keyCode) {
        boolean res = false;
        switch (keyCode) {
            case 86: {
                this.doPaste();
                res = true;
                break;
            }
            case 81: {
                this.Sair();
                res = true;
                break;
            }
            case 68: {
                this.Cancelar();
                res = true;
            }
        }
        return res;
    }

    public JDialog getJanela() {
        return this.janela;
    }

    public final void setJanela(JDialog janela) {
        this.janela = janela;
    }

    public void Sair() {
        this.Cancelar();
        this.getJanela().setVisible(false);
    }

    public void setPalavra(String str) {
        this.palavra = this.getPrompt() + str;
        this.posCursor = str.length();
        this.repaint();
    }

    public void appendHistorico(String txt) {
        if (!txt.isEmpty()) {
            this.posHist = -1;
            if (!this.historico.isEmpty() && this.historico.get(0).equals(txt)) {
                return;
            }
            this.historico.add(0, txt.substring(this.getPrompt().length()));
        }
    }

    private void posicioneHistorico(int i) {
        if (this.historico.isEmpty()) {
            return;
        }
        int tmp = this.posHist + i;
        if (tmp < 0 || tmp >= this.historico.size()) {
            this.setPalavra("");
            this.posHist = tmp < 0 ? -1 : this.historico.size();
            return;
        }
        this.posHist += i;
        String res = this.historico.get(this.posHist);
        this.setPalavra(res);
    }

    private void movimenteCursor(int i) {
        int tmp = this.posCursor + i;
        String txt = this.palavra.substring(this.prompt.length());
        if (tmp < 0 || tmp > txt.length()) {
            return;
        }
        this.posCursor = tmp;
        this.repaint();
    }

    private void AutoComplete() {
        String ac = this.getProcessador().DoAutoComplete(this.palavra.substring(this.prompt.length()).trim());
        if (!ac.isEmpty()) {
            this.setPalavra(ac);
        }
    }

    private void apagarLetra(int pos) {
        String tmp = this.palavra.substring(this.prompt.length());
        if (tmp.isEmpty() || pos > tmp.length() - 1 || pos < 0) {
            return;
        }
        int tmpTxtPos = pos + this.getPrompt().length();
        this.palavra = this.palavra.substring(0, tmpTxtPos) + (this.palavra.length() > tmpTxtPos + 1 ? this.palavra.substring(tmpTxtPos + 1, this.palavra.length()) : "");
        this.posCursor = pos;
        this.repaint();
    }
}

