/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.jfugue.pattern.Token;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;
import org.staccato.Subparser;

public class BarLineSubparser
implements Subparser {
    public static final char BARLINE = '|';
    private static BarLineSubparser instance;

    public static BarLineSubparser getInstance() {
        if (instance == null) {
            instance = new BarLineSubparser();
        }
        return instance;
    }

    @Override
    public boolean matches(String music) {
        return music.charAt(0) == '|';
    }

    @Override
    public Token.TokenType getTokenType(String tokenString) {
        if (tokenString.charAt(0) == '|') {
            return Token.TokenType.BAR_LINE;
        }
        return Token.TokenType.UNKNOWN_TOKEN;
    }

    @Override
    public int parse(String music, StaccatoParserContext context) {
        if (music.charAt(0) == '|') {
            int posNextSpace = StaccatoUtil.findNextOrEnd(music, ' ', 0);
            long measure = -1L;
            if (posNextSpace > 1) {
                String barId = music.substring(1, posNextSpace);
                measure = barId.matches("\\d+") ? Long.parseLong(barId) : (Long)context.getDictionary().get(barId);
            }
            context.getParser().fireBarLineParsed(measure);
            return Math.max(1, posNextSpace);
        }
        return 0;
    }
}

