package br.com.alura.forum.controller.form;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import br.com.alura.forum.model.Curso;
import br.com.alura.forum.model.Topico;
import br.com.alura.forum.repository.CursoRepository;
import br.com.alura.forum.repository.TopicoRepository;

public class AtualizacaoTopicoForm {

	@NotNull
	@NotEmpty
	private String titulo;

	@NotNull
	@NotEmpty
	private String mensagem;
	
	@NotNull
	@NotEmpty
	private String nomeCurso;

	public Topico getTopico(CursoRepository cursoRepository, TopicoRepository topicoRepository, Long idTopico) {
		Topico editado = topicoRepository.getOne(idTopico);
		Curso curso = cursoRepository.findByNome(this.nomeCurso);
		editado.atualizarInformacoes(titulo, mensagem, curso);
		return editado;
	}

	// setters
	public void setTitulo(String titulo) {
		this.titulo = titulo;
	}

	public void setMensagem(String mensagem) {
		this.mensagem = mensagem;
	}

	public void setNomeCurso(String nomeCurso) {
		this.nomeCurso = nomeCurso;
	}

}
