package br.com.alura.forum.model;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;

@Entity
public class Categoria {

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;
	private String nome;

	@OneToMany(mappedBy = "categoria")
	private List<Subcategoria> subcategorias = new ArrayList<>();

	// construtor default exigido pela JPA
	protected Categoria() {
	}

	public Categoria(String nome) {
		this.nome = nome;
	}

	// getters
	public Long getId() {
		return id;
	}

	public String getNome() {
		return nome;
	}

	public List<Subcategoria> getSubcategorias() {
		return subcategorias;
	}

}
