/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.devtools;

import java.util.Arrays;
import java.util.logging.Logger;
import org.jfugue.parser.ParserListener;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;

public class DiagnosticParserListener
implements ParserListener {
    private Logger logger = Logger.getLogger("org.jfugue");

    private void print(String message) {
        System.out.println(message);
        this.logger.info(message);
    }

    @Override
    public void beforeParsingStarts() {
        this.print("Before parsing starts");
    }

    @Override
    public void afterParsingFinished() {
        this.print("After parsing finished");
    }

    @Override
    public void onTrackChanged(byte track) {
        this.print("Track changed to " + track);
    }

    @Override
    public void onLayerChanged(byte layer) {
        this.print("Layer changed to " + layer);
    }

    @Override
    public void onInstrumentParsed(byte instrument) {
        this.print("Instrument parsed: " + instrument);
    }

    @Override
    public void onTempoChanged(int tempoBPM) {
        this.print("Tempo changed to " + tempoBPM + " BPM");
    }

    @Override
    public void onKeySignatureParsed(byte key, byte scale) {
        this.print("Key signature parsed: key = " + key + "  scale = " + scale);
    }

    @Override
    public void onTimeSignatureParsed(byte numerator, byte powerOfTwo) {
        this.print("Time signature parsed: " + numerator + "/" + (int)Math.pow(2.0, powerOfTwo));
    }

    @Override
    public void onBarLineParsed(long time) {
        this.print("Bar line parsed at time = " + time);
    }

    @Override
    public void onTrackBeatTimeBookmarked(String timeBookmarkId) {
        this.print("Track time bookmarked into '" + timeBookmarkId + "'");
    }

    @Override
    public void onTrackBeatTimeBookmarkRequested(String timeBookmarkId) {
        this.print("Track time bookmark looked up: '" + timeBookmarkId + "'");
    }

    @Override
    public void onTrackBeatTimeRequested(double time) {
        this.print("Track time requested: " + time);
    }

    @Override
    public void onPitchWheelParsed(byte lsb, byte msb) {
        this.print("Pitch wheel parsed, lsb = " + lsb + "  msb = " + msb);
    }

    @Override
    public void onChannelPressureParsed(byte pressure) {
        this.print("Channel pressure parsed: " + pressure);
    }

    @Override
    public void onPolyphonicPressureParsed(byte key, byte pressure) {
        this.print("Polyphonic pressure parsed, key = " + key + "  pressure = " + pressure);
    }

    @Override
    public void onSystemExclusiveParsed(byte ... bytes) {
        this.print("Sysex parsed, bytes = " + Arrays.toString(bytes));
    }

    @Override
    public void onControllerEventParsed(byte controller, byte value) {
        this.print("Controller event parsed, controller = " + controller + "  value = " + value);
    }

    @Override
    public void onLyricParsed(String lyric) {
        this.print("Lyric parsed: " + lyric);
    }

    @Override
    public void onMarkerParsed(String marker) {
        this.print("Marker parsed: " + marker);
    }

    @Override
    public void onFunctionParsed(String id, Object message) {
        this.print("User event parsed, id = " + id + "  message = " + message);
    }

    @Override
    public void onNotePressed(Note note) {
        this.print("Note pressed: value = " + note.getValue() + "  onVelocity = " + note.getOnVelocity());
    }

    @Override
    public void onNoteReleased(Note note) {
        this.print("Note released: value = " + note.getValue() + "  offVelocity = " + note.getOffVelocity());
    }

    @Override
    public void onNoteParsed(Note note) {
        this.print("Note parsed: value = " + note.getValue() + "  duration = " + note.getDuration() + "  onVelocity = " + note.getOnVelocity() + "  offVelocity = " + note.getOffVelocity());
    }

    @Override
    public void onChordParsed(Chord chord) {
        this.print("Chord parsed: rootnote = " + chord.getRoot().getValue() + "  intervals = " + chord.getIntervals().toString() + "  duration = " + chord.getRoot().getDuration() + "  onVelocity = " + chord.getRoot().getOnVelocity() + "  offVelocity = " + chord.getRoot().getOffVelocity());
    }
}

