/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.pattern;

import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.theory.Note;
import org.staccato.IVLSubparser;
import org.staccato.StaccatoParserContext;

public class Atom
implements PatternProducer {
    private byte voice;
    private byte layer;
    private byte instrument;
    private Note note;
    private String contents;

    public Atom(byte voice, byte layer, byte instrument, String note) {
        this(voice, layer, instrument, new Note(note));
    }

    public Atom(byte voice, byte layer, byte instrument, Note note) {
        this.createAtom(voice, layer, instrument, note);
    }

    public Atom(String voice, String layer, String instrument, String note) {
        this(voice, layer, instrument, new Note(note));
    }

    public Atom(String voice, String layer, String instrument, Note note) {
        StaccatoParserContext context = new StaccatoParserContext(null);
        IVLSubparser.populateContext(context);
        this.createAtom(IVLSubparser.getInstance().getValue(voice.toUpperCase(), context), IVLSubparser.getInstance().getValue(layer.toUpperCase(), context), IVLSubparser.getInstance().getValue(instrument.toUpperCase(), context), new Note(note));
    }

    private void createAtom(byte voice, byte layer, byte instrument, Note note) {
        this.voice = voice;
        this.layer = layer;
        this.instrument = instrument;
        this.note = note;
        StringBuilder buddy = new StringBuilder();
        buddy.append('&');
        buddy.append('V');
        buddy.append(voice);
        buddy.append(",");
        buddy.append('L');
        buddy.append(layer);
        buddy.append(",");
        buddy.append('I');
        buddy.append(instrument);
        buddy.append(",");
        buddy.append(note);
        this.contents = buddy.toString();
    }

    public byte getVoice() {
        return this.voice;
    }

    public byte getLayer() {
        return this.layer;
    }

    public byte getInstrument() {
        return this.instrument;
    }

    public Note getNote() {
        return this.note;
    }

    public String toString() {
        return this.contents;
    }

    @Override
    public Pattern getPattern() {
        return new Pattern(this.contents);
    }
}

