/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.jfugue.parser.Parser;
import org.jfugue.theory.Key;
import org.jfugue.theory.TimeSignature;

public class StaccatoParserContext {
    private Parser parser;
    private Map<String, Object> dictionary;
    private Key currentKey = Key.DEFAULT_KEY;
    private TimeSignature currentTimeSignature = TimeSignature.DEFAULT_TIMESIG;

    public StaccatoParserContext(Parser parser) {
        this.parser = parser;
        this.dictionary = new HashMap<String, Object>();
    }

    public Map<String, Object> getDictionary() {
        return this.dictionary;
    }

    public StaccatoParserContext loadDictionary(Reader reader) throws IOException {
        BufferedReader bread = new BufferedReader(reader);
        while (bread.ready()) {
            String s = bread.readLine();
            if (s == null || s.length() <= 1 || s.charAt(0) == '#' || s.charAt(0) != '$') continue;
            String key = s.substring(1, s.indexOf(61)).trim();
            String value = s.substring(s.indexOf(61) + 1, s.length()).trim();
            this.dictionary.put(key, value);
        }
        bread.close();
        return this;
    }

    public Parser getParser() {
        return this.parser;
    }

    public StaccatoParserContext loadDictionary(InputStream stream) throws IOException {
        return this.loadDictionary(new InputStreamReader(stream));
    }

    public StaccatoParserContext loadDictionary(File file) throws IOException {
        return this.loadDictionary(new FileReader(file));
    }

    public StaccatoParserContext setKey(Key key) {
        this.currentKey = key;
        return this;
    }

    public Key getKey() {
        return this.currentKey;
    }

    public StaccatoParserContext setTimeSignature(TimeSignature timeSignature) {
        this.currentTimeSignature = timeSignature;
        return this;
    }

    public TimeSignature getTimeSignature() {
        return this.currentTimeSignature;
    }
}

