/*
 * Decompiled with CFR 0.152.
 */
package desenho.preAnyDiagrama;

import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.linhas.PontoDeLinha;
import desenho.linhas.SuperLinha;
import desenho.preAnyDiagrama.PreCardinalidade;
import desenho.preAnyDiagrama.PreEntidade;
import desenho.preAnyDiagrama.PreRelacionamento;
import java.awt.Point;
import java.util.ArrayList;

public class PreLigacao
extends SuperLinha {
    private static final long serialVersionUID = 4654449532952974461L;
    private PreCardinalidade Card;

    public PreLigacao(Diagrama diagrama) {
        super(diagrama);
        this.setInteligente(true);
    }

    public PreLigacao(Diagrama diagrama, PreCardinalidade aCard) {
        super(diagrama);
        this.setInteligente(true);
        this.InitLCC(aCard);
        diagrama.Remove(aCard, false);
    }

    protected final void InitLCC(PreCardinalidade aCard) {
        this.setCard(aCard);
        this.PrepareCardinalidade();
    }

    public PreCardinalidade getCard() {
        return this.Card;
    }

    public void setCard(PreCardinalidade aCard) {
        if (this.Card != aCard) {
            if (this.Card != null) {
                this.Card.setLigadoA(null);
            }
            this.Card = aCard;
            if (this.Card != null) {
                this.Card.setLigadoA(this);
            }
        }
    }

    public boolean isCardVisible() {
        if (this.Card != null) {
            return this.Card.isVisible();
        }
        return false;
    }

    public void PrepareCardinalidade() {
    }

    @Override
    public void reSetBounds() {
        super.reSetBounds();
        this.PrepareCardinalidade();
    }

    @Override
    public boolean AnexePontos() {
        boolean res = super.AnexePontos();
        if (!res) {
            this.PrepareCardinalidade();
        }
        return res;
    }

    @Override
    public boolean Destroy() {
        ArrayList<PontoDeLinha> pontos = this.getPontos();
        for (PontoDeLinha pdl : pontos) {
            pdl.Destroy();
        }
        if (this.Card != null) {
            this.Card.setCanBeDeleted(true);
            this.getMaster().Remove(this.Card, false);
        }
        return super.Destroy();
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        GP = super.CompleteGenerateProperty(GP);
        GP.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "linha.centre").setTag(140916));
        ArrayList<Forma> lst = new ArrayList<Forma>();
        if (this.getPontaA().getEm() != null) {
            lst.add(this.getPontaA().getEm());
        }
        if (this.getPontaB().getEm() != null) {
            lst.add(this.getPontaB().getEm());
        }
        if (this.isCardVisible()) {
            lst.add(0, this.Card);
        }
        boolean ja = false;
        for (Forma f : lst) {
            InspectorProperty ipp = InspectorProperty.PropertyFactoryActionSelect(Editor.fromConfiguracao.getValor("diagrama." + Editor.getClassTexto(f) + ".nome"), f.getTexto(), String.valueOf(f.getID()));
            if (!ja) {
                ja = true;
                GP.add(InspectorProperty.PropertyFactorySeparador("ligacoes"));
            }
            GP.add(ipp);
        }
        return GP;
    }

    @Override
    public FormaElementar getSub(int i) {
        if (i == 0) {
            return this.getCard();
        }
        return super.getSub(i);
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        if (Tag == 140916) {
            this.CentralizarByEntidade();
        }
    }

    public void CentralizarByEntidade() {
        Point pt;
        PontoDeLinha P;
        Forma A;
        int L = -1;
        if (this.getFormaPontaA() instanceof PreEntidade || this.getFormaPontaA() instanceof PreRelacionamento) {
            L = this.getPontaA().getLado();
            A = this.getFormaPontaA();
            P = this.getPontaA();
            pt = A.getPontosCalculados()[L];
            P.setCentro(pt);
        }
        if (this.getFormaPontaB() instanceof PreEntidade || this.getFormaPontaB() instanceof PreRelacionamento) {
            L = this.getPontaB().getLado();
            A = this.getFormaPontaB();
            P = this.getPontaB();
            pt = A.getPontosCalculados()[L];
            P.setCentro(pt);
        }
        if (L > -1) {
            this.OrganizeLinha();
            this.reSetBounds();
            this.DoMuda();
        }
    }
}

