/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.staccato.Preprocessor;
import org.staccato.PreprocessorFunction;
import org.staccato.StaccatoParserContext;
import org.staccato.functions.FunctionManager;

public class FunctionPreprocessor
implements Preprocessor {
    private static FunctionPreprocessor instance;
    private static Pattern functionPattern;
    private static Pattern namePattern;
    private static Pattern paramPattern;

    private FunctionPreprocessor() {
    }

    public static FunctionPreprocessor getInstance() {
        if (instance == null) {
            instance = new FunctionPreprocessor();
        }
        return instance;
    }

    @Override
    public String preprocess(String s, StaccatoParserContext context) {
        StringBuilder buddy = new StringBuilder();
        int posPrev = 0;
        Matcher m = functionPattern.matcher(s);
        while (m.find()) {
            String functionName = null;
            String parameters = null;
            Matcher nameMatcher = namePattern.matcher(m.group());
            while (nameMatcher.find()) {
                functionName = nameMatcher.group().substring(1, nameMatcher.group().length() - 1);
            }
            PreprocessorFunction function = FunctionManager.getInstance().getPreprocessorFunction(functionName);
            if (function == null) {
                return s;
            }
            Matcher paramMatcher = paramPattern.matcher(m.group());
            while (paramMatcher.find()) {
                parameters = paramMatcher.group().substring(1, paramMatcher.group().length() - 1);
            }
            buddy.append(s.substring(posPrev, m.start()));
            buddy.append(function.apply(parameters, context));
            posPrev = m.end();
        }
        buddy.append(s.substring(posPrev, s.length()));
        return buddy.toString();
    }

    static {
        functionPattern = Pattern.compile(":\\S+\\(\\p{ASCII}*\\)");
        namePattern = Pattern.compile(":\\S+\\(");
        paramPattern = Pattern.compile("\\(\\p{ASCII}*\\)");
    }
}

