/*
 * Decompiled with CFR 0.152.
 */
package diagramas.livre;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.formas.FormaNaoRetangularDisformeBase;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.XMLGenerate;

public class LivreBase
extends FormaNaoRetangularDisformeBase {
    private static final long serialVersionUID = 634717196393984568L;
    private TipoDraw tipoDesenho = TipoDraw.tpRetangulo;
    private boolean dashed = false;
    protected boolean noNewProperty = false;
    private boolean gradiente = true;
    private Color gradienteEndColor = Color.WHITE;
    private Color gradienteStartColor = Color.BLACK;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int gdirecao = 0;
    private float alfa = 0.8f;

    public LivreBase(Diagrama modelo, String texto) {
        super(modelo, texto);
    }

    public LivreBase(Diagrama modelo) {
        super(modelo);
    }

    public TipoDraw getTipoDesenho() {
        return this.tipoDesenho;
    }

    protected void setTipoDesenho(TipoDraw tipoDesenho) {
        if (this.tipoDesenho != tipoDesenho) {
            this.setRegiao(null);
            this.ptsToMove = new int[]{-1, -1, -1, -1};
            this.tipoDesenho = tipoDesenho;
            this.InvalidateArea();
        }
    }

    @Override
    protected void PinteRegiao(Graphics2D g) {
        Composite originalComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, this.alfa));
        g.setPaint(this.getForeColor());
        if (this.isGradiente()) {
            int dist = 0;
            int w = this.getWidth() - dist;
            int h = this.getHeight() - dist;
            int L = this.getLeft();
            int T = this.getTop();
            boolean dv = this.getGDirecao() == 0;
            GradientPaint GP = new GradientPaint(L, T, this.getGradienteStartColor(), dv ? (float)L : (float)(L + w), dv ? (float)(T + h) : (float)T, this.getGradienteEndColor(), true);
            g.setPaint(GP);
        }
        if (this.getTipoDesenho() != TipoDraw.tpTexto) {
            Stroke bkp = g.getStroke();
            if (this.isDashed()) {
                g.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
            }
            if (this.isGradiente()) {
                g.fill(this.getRegiao());
            }
            g.draw(this.getRegiao());
            g.setStroke(bkp);
        }
        g.setComposite(originalComposite);
    }

    public boolean isDashed() {
        return this.dashed;
    }

    public void setDashed(boolean dasehd) {
        if (this.dashed != dasehd) {
            this.dashed = dasehd;
            this.DoMuda();
            this.InvalidateArea();
        }
    }

    @Override
    public Shape getRegiao() {
        switch (this.getTipoDesenho()) {
            case tpRetanguloArred: {
                return this.getRegiaoRecArred();
            }
            case tpCirculo: {
                return this.getRegiaoCirculo();
            }
            case tpLosango: {
                return this.getRegiaoLosanglo();
            }
            case tpDocSimples: {
                return this.getRegiaoDocumento();
            }
            case tpNota: {
                return this.getRegiaoNota();
            }
            case tpVariosDocumentos: {
                return this.getRegiaoVDocumentos();
            }
            case tpComentario: {
                return this.getRegiaoComentario();
            }
        }
        return this.getRegiaoRec();
    }

    public Shape getRegiaoDocumento() {
        if (this.Regiao == null) {
            int v1 = this.getHeight() / 3;
            int h1 = this.getWidth() / 2;
            int repo = v1 / 3;
            int L = this.getLeft();
            int T = this.getTop();
            int TH = T + this.getHeight() - repo;
            int LW = L + this.getWidth();
            CubicCurve2D.Double c = new CubicCurve2D.Double();
            ((CubicCurve2D)c).setCurve(L, TH, L + h1, TH + v1, LW - h1, TH - v1, LW, TH);
            GeneralPath pa = new GeneralPath();
            pa.moveTo(LW, TH);
            pa.lineTo(LW, T);
            pa.lineTo(L, T);
            pa.lineTo(L, TH);
            pa.append(c, true);
            this.Regiao = pa;
            int ptToMove = 3;
            this.reposicionePonto[3] = new Point(0, -repo);
            this.ptsToMove[3] = 1;
        }
        return this.Regiao;
    }

    public Shape getRegiaoVDocumentos() {
        if (this.Regiao == null) {
            int v1 = this.getHeight() / 3;
            int h1 = this.getWidth() / 2;
            int repo = v1 / 3;
            int L = this.getLeft();
            int recuo = h1 / 8;
            int T = this.getTop() + recuo;
            int TH = T + this.getHeight() - repo - recuo;
            int LW = L + this.getWidth() - recuo;
            CubicCurve2D.Double c = new CubicCurve2D.Double();
            ((CubicCurve2D)c).setCurve(L, TH, L + h1, TH + v1, LW - h1, TH - v1, LW, TH);
            GeneralPath pa = new GeneralPath();
            pa.setWindingRule(0);
            pa.moveTo(LW, TH);
            pa.lineTo(LW, T);
            pa.lineTo(L, T);
            pa.lineTo(L, TH);
            pa.append(c, false);
            int tam = recuo / 2;
            pa.moveTo(L + tam, T);
            pa.lineTo(L + tam, T - tam);
            pa.lineTo(LW + tam, T - tam);
            pa.lineTo(LW + tam, TH - tam);
            pa.lineTo(LW, TH - tam);
            pa.lineTo(LW, T);
            pa.lineTo(L + tam, T);
            tam = recuo;
            pa.moveTo(L + tam, T - tam / 2);
            pa.lineTo(L + tam, T - tam);
            pa.lineTo(LW + tam, T - tam);
            pa.lineTo(LW + tam, TH - tam);
            pa.lineTo(LW + tam / 2, TH - tam);
            pa.lineTo(LW + tam / 2, T - tam / 2);
            pa.lineTo(L + tam, T - tam / 2);
            pa.closePath();
            this.Regiao = pa;
            int ptToMove = 3;
            this.reposicionePonto[3] = new Point(-tam / 2, -repo);
            this.ptsToMove[3] = 1;
        }
        return this.Regiao;
    }

    public Shape getRegiaoNota() {
        if (this.Regiao == null) {
            int v1 = this.getHeight() / 3;
            int h1 = this.getWidth() / 2;
            int repo = v1 / 3;
            int L = this.getLeft();
            int T = this.getTop();
            int TH = T + this.getHeight() - repo;
            int LW = L + this.getWidth();
            CubicCurve2D.Double c = new CubicCurve2D.Double();
            ((CubicCurve2D)c).setCurve(LW, TH, LW - h1, TH - v1, L + h1, TH + v1, L, TH);
            CubicCurve2D.Double c2 = new CubicCurve2D.Double();
            int v2 = v1 / 3;
            ((CubicCurve2D)c2).setCurve(L, T + v2, L + h1, T + v1 + v2, LW - h1, T - v1 + v2, LW, T + v2);
            GeneralPath pa = new GeneralPath();
            pa.setWindingRule(0);
            pa.append(c2, true);
            pa.lineTo(LW, TH);
            pa.append(c, true);
            pa.lineTo(L, T + v2);
            pa.closePath();
            this.Regiao = pa;
            int ptToMove = 3;
            this.reposicionePonto[ptToMove] = new Point(0, -repo);
            this.ptsToMove[ptToMove] = 1;
            ptToMove = 1;
            this.reposicionePonto[ptToMove] = new Point(0, repo);
            this.ptsToMove[ptToMove] = 1;
        }
        return this.Regiao;
    }

    public Shape getRegiaoLosanglo() {
        if (this.Regiao == null) {
            Rectangle r = new Rectangle(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
            Polygon los = new Polygon();
            los.addPoint(r.x, r.y + r.height / 2);
            los.addPoint(r.x + r.width / 2, r.y);
            los.addPoint(r.x + r.width, r.y + r.height / 2);
            los.addPoint(r.x + r.width / 2, r.y + r.height);
            this.Regiao = los;
        }
        return this.Regiao;
    }

    public Shape getRegiaoCirculo() {
        if (this.Regiao == null) {
            this.Regiao = new Ellipse2D.Float(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        }
        return this.Regiao;
    }

    public Shape getRegiaoRecArred() {
        if (this.Regiao == null) {
            this.Regiao = new RoundRectangle2D.Float(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), this.getWidth() / 3, this.getHeight());
        }
        return this.Regiao;
    }

    public Shape getRegiaoRec() {
        if (this.Regiao == null) {
            this.Regiao = new Rectangle2D.Float(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        }
        return this.Regiao;
    }

    public Shape getRegiaoComentario() {
        if (this.Regiao == null) {
            GeneralPath pa = new GeneralPath();
            pa.setWindingRule(1);
            Rectangle rec = this.getBounds();
            int tam = Math.min(rec.width / 6, rec.height / 6);
            int curv = tam / 4;
            int lw = rec.x + rec.width;
            int[] px = new int[]{rec.x, lw - tam, lw, lw, rec.x};
            int[] py = new int[]{rec.y, rec.y, rec.y + tam, rec.y + rec.height, rec.y + rec.height};
            Polygon po = new Polygon(px, py, 5);
            pa.append(po, true);
            pa.moveTo(lw - tam, rec.y);
            pa.curveTo(lw - tam, rec.y, lw - tam + curv, rec.y + curv, lw - tam, rec.y + tam - 1);
            pa.moveTo(lw - tam, rec.y + tam - 1);
            pa.lineTo(lw, rec.y + tam);
            pa.closePath();
            this.Regiao = pa;
        }
        return this.Regiao;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Dashed", this.isDashed()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Gradiente", this.isGradiente()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteStartColor", this.getGradienteStartColor()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteEndColor", this.getGradienteEndColor()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "GDirecao", this.getGDirecao()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Alfa", (int)(100.0f * this.getAlfa())));
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        int l;
        this.setDashed(XMLGenerate.getValorBooleanFrom(me, "Dashed"));
        this.setGradiente(XMLGenerate.getValorBooleanFrom(me, "Gradiente"));
        Color c = XMLGenerate.getValorColorFrom(me, "GradienteStartColor");
        if (c != null) {
            this.setGradienteStartColor(c);
        }
        if ((c = XMLGenerate.getValorColorFrom(me, "GradienteEndColor")) != null) {
            this.setGradienteEndColor(c);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "GDirecao")) != -1) {
            this.setGDirecao(l);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "Alfa")) != -1) {
            this.SetAlfa(l);
        }
        return super.LoadFromXML(me, colando);
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        if (this.noNewProperty) {
            return super.CompleteGenerateProperty(GP);
        }
        GP.add(InspectorProperty.PropertyFactorySN("linha.dashed", "setDashed", this.isDashed()));
        GP.add(InspectorProperty.PropertyFactoryNumero("diagrama.detalhe.alfa", "SetAlfa", (int)(100.0f * this.getAlfa())));
        ArrayList<InspectorProperty> res = GP;
        res.add(InspectorProperty.PropertyFactorySeparador("texto.gradiente", true));
        String[] grupo = new String[]{"setGradienteStartColor", "setGradienteEndColor", "setGDirecao"};
        res.add(InspectorProperty.PropertyFactorySN("texto.gradiente.is", "setGradiente", this.isGradiente()).AddCondicaoForFalse(new String[]{"setBackColor"}).AddCondicaoForTrue(grupo));
        res.add(InspectorProperty.PropertyFactoryCor("texto.gradiente.startcor", "setGradienteStartColor", this.getGradienteStartColor()));
        res.add(InspectorProperty.PropertyFactoryCor("texto.gradiente.endcor", "setGradienteEndColor", this.getGradienteEndColor()));
        res.add(InspectorProperty.PropertyFactoryMenu("texto.gradiente.direcao", "setGDirecao", this.getGDirecao(), Editor.fromConfiguracao.getLstDirecao(Controler.Comandos.cmdTexto)));
        return super.CompleteGenerateProperty(GP);
    }

    public Color getGradienteStartColor() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteStartColor;
    }

    public void setGradienteStartColor(Color gradienteStartColor) {
        this.gradienteStartColor = gradienteStartColor;
        this.InvalidateArea();
    }

    public boolean isGradiente() {
        return this.gradiente;
    }

    public void setGradiente(boolean gradiente) {
        this.gradiente = gradiente;
        this.InvalidateArea();
    }

    public Color getGradienteEndColor() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteEndColor;
    }

    public void setGradienteEndColor(Color gradienteEndColor) {
        this.gradienteEndColor = gradienteEndColor;
        this.InvalidateArea();
    }

    public float getAlfa() {
        return this.alfa;
    }

    public void setAlfa(float alfa) {
        this.alfa = alfa;
    }

    public void SetAlfa(int alfa) {
        this.alfa = (float)alfa / 100.0f;
        if (this.alfa > 1.0f) {
            this.alfa = 0.5f;
        }
        this.InvalidateArea();
    }

    public int getGDirecao() {
        return this.gdirecao;
    }

    public void setGDirecao(int aDirection) {
        this.gdirecao = aDirection;
        this.InvalidateArea();
    }

    public static enum TipoDraw {
        tpTexto,
        tpRetangulo,
        tpRetanguloArred,
        tpCirculo,
        tpLosango,
        tpDocSimples,
        tpNota,
        tpVariosDocumentos,
        tpComentario;

    }
}

